<?php
/**
 * @package CleverOgre
 * @subpackage WP Job Manager - JobAdder Integration
 * @since WP Job Manager - JobAdder Integration 0.1.1
 */

namespace JobAdder\API;

if (!defined('ABSPATH')) exit;

class Contacts {

    public static function getContact(int $contactId) {
        $url = \JobAdder\API\Utility::buildApiIdUrl(JOBADDER_CONTACTS_ENDPOINT, $contactId);
        if (!$url) return false;

        $data = \JobAdder\API\Utility::getJson($url);
        if (!$data || !isset($data['contactId'])) return false;

        return (array)$data;
    }

}
