<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

class Item {

    public static function load() {
        add_action('init', [__CLASS__, 'init']);
        add_filter('ogre/blocks', [__CLASS__, 'blocks'], 10, 1);
        add_filter('ogretemplate/article_meta_items', [__CLASS__, 'meta_items'], 10, 2);
        add_filter('ogretemplate/excerpt/entry_link_text', [__CLASS__, 'entry_link_text'], 10, 2);
        add_action('ogre/excerpt_inner_before', [__CLASS__, 'popular_tag'], 10, 1);
        add_filter('ogre/page_settings_post_types', [__CLASS__, 'add_page_settings'], 10, 1);
    }

    static function init() {
        register_post_type(self::get_post_type(), apply_filters('ogre/fareharbor/item_post_type_args', [
            'labels' => apply_filters('ogre/fareharbor/item_post_type_labels', \Ogre::get_labels(__('Items', 'fareharbor-api'), __('Item', 'fareharbor-api'))),
            'supports' => ['title', 'editor', 'thumbnail', 'revisions', 'excerpt'],
            'exclude_from_search' => false,
            'public' => true,
            'publicly_queryable' => true,
            'show_in_nav_menus' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'has_archive' => true,
            'show_in_admin_bar' => true,
            'menu_position' => 5,
            'taxonomies' => [],
            'menu_icon' => 'dashicons-palmtree',
            'rewrite' => ['slug' => 'item'],
            'show_in_rest' => apply_filters('ogre/fareharbor/item_block_editor', true),
        ]));
    }

    static function blocks($blocks) {
        $block_names = wp_list_pluck($blocks, 'name');

        if (!in_array('products', $block_names)) {
            $blocks[] = [
                'name' => 'products',
                'title' => __('Products', 'fareharbor-api'),
                'icon' => 'products',
                'align' => false,
                'mode' => 'preview',
            ];
        }

        if (!in_array('review', $block_names)) {
            $blocks[] = [
                'name' => 'review',
                'title' => __('Review', 'fareharbor-api'),
                'icon' => 'format-quote',
                'align' => false,
                'mode' => false,
            ];
        }

        return $blocks;
    }

    static function meta_items($items, $post_id) {
        if (get_post_type($post_id) != self::get_post_type() || !function_exists('get_field')) return $items;

        $items = [];
        return $items;
    }

    static function entry_link_text($text, $post_id) {
        if (get_post_type($post_id) != self::get_post_type()) return $text;
        return apply_filters('ogre/fareharbor/entry_link_text', __('Book This Tour', 'fareharbor-api'));
    }

    static function popular_tag($post_id) {
        if (get_post_type($post_id) != self::get_post_type() || get_field('popular', $post_id) !== true) return;
        printf('<span class="entry-popular">%s</span>', apply_filters('ogre/fareharbor/popular_tag_text', __('Most Popular', 'fareharbor-api')));
    }

    static function add_page_settings($post_types) {
        if (!in_array(self::get_post_type(), $post_types)) $post_types[] = self::get_post_type();
        return $post_types;
    }

    public static function get_post_type() {
        return apply_filters('ogre/fareharbor/item_post_type', 'fareharbor_item');
    }

    public static function get_id_by_pk($pk) {
        if (!is_numeric($pk)) return false;
        $args = [
            'post_type' => self::get_post_type(),
            'posts_per_page' => 1,
            'offset' => 0,
            'meta_query' => [[
                'key' => Meta::get_key('pk'),
                'value' => intval($pk),
                'compare' => '=',
            ]],
            'fields' => 'ids',
        ];
        $query = new \WP_Query($args);
        if (empty($query->posts)) return false;
        return reset($query->posts);
    }

    public static function update_by_data($data, $create = true) {
        if (!isset($data['pk']) || !is_numeric($data['pk'])) return false;

        $post_id = get_id_by_pk($data['pk']);
        if (!is_int($post_id) && $create === true) {
            $post_id = wp_insert_post([
                'post_type' => self::get_post_type(),
                'post_status' => 'publish',
                'meta_input' => [
                    Meta::get_key('sync') => true,
                    Meta::get_key('pk') => intval($data['pk']),
                ],
            ]);
        }
        if (!is_int($post_id) || get_post_type($post_id) != self::get_post_type()) return false;
        unset($data['pk']);

        if (!Meta::update_data($post_id, $data)) return false;

        self::build_content($post_id);

        return true;
    }

    private static function build_content($post_id) {
        if (!is_int($post_id) || get_post_type($post_id) != self::get_post_type()) return false;

        $postarr = [
            'ID' => $post_id,
            'post_title' => Meta::get_value($post_id, 'name'),
            'post_content' => Meta::get_value($post_id, 'description'),
        ];

        $result = wp_update_post($postarr);
        if ($result === 0 || is_wp_error($result)) return false;

        if (function_exists('update_field')) {
            update_field('page_title_alternate', Meta::get_value($post_id, 'headline'), $post_id);
        }

        return true;
    }

}

Item::load();
