<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

class Template {

    public static function load() {
        add_filter('ogretemplate/archive/active_sidebar', [__CLASS__, 'active_sidebar'], 10, 1);
        add_filter('ogretemplate/article_header_image', [__CLASS__, 'header_image'], 10, 2);
        add_filter('ogretemplate/article_classes', [__CLASS__, 'image_classes'], 10, 4);
        add_filter('ogretemplate/article_header_classes', [__CLASS__, 'image_classes'], 10, 4);

        // Content Actions
        add_action('ogre/fareharbor/the_content', 'the_fareharbor_gallery', 10, 1);
        add_action('ogre/fareharbor/the_content', 'the_fareharbor_bullets', 20, 1);
    }

    static function active_sidebar($sidebar_id) {
        if (is_singular(Item::get_post_type())) return false;
        return $sidebar_id;
    }

    static function header_image($image, $post_id) {
        if (get_post_type($post_id) != Item::get_post_type()) return $image;
        if (!empty($image)) return $image;

        $image_url = Meta::get_value($post_id, 'image_cdn_url');
        if (empty($image_url) || !wp_http_validate_url($image_url)) return $image;
        return [
            'ID' => -1,
            'alt' => get_the_title($post_id),
            'title' => get_the_title($post_id),
            'caption' => '',
            'description' => '',
            'mime_type' => wp_check_filetype(wp_basename($image_url))['type'],
            'type' => 'image',
            'url' => $image_url,
            'width' => '',
            'height' => '',
            'sizes' => [],
        ];
    }

    static function image_classes($classes, $post_id, $post_type, $post) {
        if ($post_type != Item::get_post_type()) return $classes;
        $image_url = Meta::get_value($post_id, 'image_cdn_url');
        if (!in_array('has-image', $classes) && !empty($image_url) && wp_http_validate_url($image_url)) $classes[] = 'has-image';
        return $classes;
    }

    public static function get_template_part($slug, $name = null, $args = [], $plugin_only = false) {
        do_action("get_template_part_{$slug}", $slug, $name, $args);

        $templates = [];
        $name = (string) $name;
        if ('' !== $name) $templates[] = "{$slug}-{$name}.php";

        $templates[] = "{$slug}.php";

        do_action('get_template_part', $slug, $name, $templates, $args);
        if (!self::locate_template($templates, true, false, $args, $plugin_only)) {
            return false;
        }
    }
    public static function load_template_part($template_name, $part_name = null, $args = [], $plugin_only = false) {
        ob_start();
        self::get_template_part($template_name, $part_name, $args, $plugin_only);
        $var = ob_get_contents();
        ob_end_clean();
        return $var;
    }
    public static function include_template_part($data, $template_name, $part_name = null, $args = [], $plugin_only = false) {
        $templates = array();
        if (!empty($part_name)) {
            $templates[] = "{$template_name}-{$part_name}.php";
        }
        $templates[] = "{$template_name}.php";

        ob_start();
        extract($data);
        include(self::locate_template($templates, false, false, $args, $plugin_only));
        $var = ob_get_contents();
        ob_end_clean();
        return $var;
    }
    protected function locate_template($template_names, $load = false, $require_once = true, $args = [], $plugin_only = false) {
        $located = '';
        foreach ((array)$template_names as $template_name) {
            if (!$template_name) continue;
            if (!$plugin_only && file_exists(STYLESHEETPATH . '/fareharbor/' . $template_name)) {
                $located = STYLESHEETPATH . '/fareharbor/' . $template_name;
                break;
            } elseif (!$plugin_only && file_exists(TEMPLATEPATH . '/fareharbor/' . $template_name)) {
                $located = TEMPLATEPATH . '/fareharbor/' . $template_name;
                break;
            } elseif (file_exists(Plugin::get_path() . 'templates/' . $template_name)) {
                $located = Plugin::get_path() . 'templates/' . $template_name;
                break;
            } elseif (file_exists(ABSPATH . WPINC . '/theme-compat/fareharbor/' . $template_name)) {
                $located = ABSPATH . WPINC . '/theme-compat/fareharbor/' . $template_name;
                break;
            }
        }

        if ($load && '' !== $located) {
            load_template($located, $require_once, $args);
        }

        return $located;
    }

}

Template::load();
