<?php
/**
 * @package CleverOgre
 * @subpackage OgreSchema
 * @version 0.1.0
 * @since 0.1.0
 */

namespace OgreSchema;

if (!defined('ABSPATH')) exit;

class Fields {
    use Singleton;

    public function __construct() {
        add_filter('acf/get_field_group', [$this, 'assign_post_type_locations'], 10, 1);
        add_filter('acf/load_field/key=field_5c62eb9db90a6', [$this, 'load_post_types'], 10, 1);
        add_filter('acf/load_field/key=field_5a05e86e18797', [$this, 'load_business_types'], 10, 1);
        add_filter('acf/load_field/key=field_5a09f1e06f181', [$this, 'load_organization_types'], 10, 1);
    }

    public function assign_post_type_locations(array $group):array {
        if ($group['key'] !== 'group_5a05f48ad5e1a' || !Settings::has_post_types()) return $group;
        foreach (Settings::get_post_types() as $post_type) {
            if (is_null(get_post_type_object($post_type))) continue;
            $group['location'][] = [[
                'param' => 'post_type',
                'operator' => '==',
                'value' => $post_type,
            ]];
        }
        return $group;
    }

    public function load_post_types(array $field):array {
        $field['choices'] = wp_list_pluck(get_post_types(['public' => true], 'objects'), 'label', 'name');
        return $field;
    }

    public function load_business_types(array $field):array {
        $field['choices'] = $this->get_json_data('data/business-type.json');
        return $field;
    }

    public function load_organization_types(array $field):array {
        $field['choices'] = $this->get_json_data('data/organization-type.json');
        return $field;
    }

    private function get_json_data(string $relpath):array {
        $path = Plugin::instance()->get_path() . ltrim($relpath, '/');
        if (!str_ends_with($path, '.json') || !file_exists($path)) return [];
        $data = json_decode(file_get_contents($path), true);
        return is_array($data) ? $data : [];
    }

}

Fields::instance();
