<?php
/**
 * @package CleverOgre
 * @subpackage woocommerce-download-template
 * @version 0.1.0
 * @since 0.1.0
 */

namespace WooCommerce\DownloadTemplate\Values;

defined('ABSPATH') || exit;

use WooCommerce\DownloadTemplate\Singleton;

abstract class Appender {
    use Singleton;

    private int $priority = 10;

    public function __construct() {
        add_filter('wc_download_template_values_default_args', [$this, 'get_default_args'], $this->priority, 1);
        add_filter('wc_download_template_values_args', [$this, 'validate_args'], $this->priority, 1);
        add_filter('wc_download_template_default_values', [$this, 'get_default'], $this->priority, 1);
        add_filter('wc_download_template_values', [$this, 'get'], $this->priority, 2);
        add_filter('wc_download_template_example_values', [$this, 'get_example'], $this->priority, 1);
    }

    public function get_default_args(array $args = []):array {
        return $args;
    }

    public function validate_args(array $args = []):array {
        return $args;
    }

    public function get_default(array $values = []):array {
        return $values;
    }

    public function get(array $values = [], array $args = []):array {
        return $values;
    }

    public function get_example(array $values = []):array {
        return $values;
    }

}
