<?php
/**
 * @package WooCommerce
 * @subpackage NewtekGateway
 * @version 1.2.0
 * @since 1.2.0
 */

namespace WooCommerce\NewtekGateway;

defined('ABSPATH') || exit;

use \Automattic\WooCommerce\StoreApi\Payments\PaymentContext;
use \Automattic\WooCommerce\StoreApi\Payments\PaymentResult;
use Automattic\WooCommerce\StoreApi\Utilities\NoticeHandler;

class RestProcessPayment {
    use Singleton;

	public function __construct() {
		add_action('woocommerce_rest_checkout_process_payment_with_context', [$this, 'process_payment'], 10, 2);
	}

	public function process_payment(PaymentContext $context, PaymentResult &$result) {
		if ($result->status) return;

        // phpcs:ignore WordPress.Security.NonceVerification
		$post_data = $_POST;

        // Set constants.
		wc_maybe_define_constant( 'WOOCOMMERCE_CHECKOUT', true );

        $payment_method_object = $context->get_payment_method_instance();
        if (!$payment_method_object instanceof \WC_Payment_Gateway) return;
        if ($payment_method_object->id !== Plugin::get_id()) return;

        // Add the payment data from the API to the POST global.
		$_POST = $context->payment_data;

        $payment_method_object->validate_fields();

		// If errors were thrown, we need to abort.
		NoticeHandler::convert_notices_to_exceptions('woocommerce_rest_payment_error');

        // Process Payment.
        $gateway_result = $payment_method_object->process_payment( $context->order->get_id() );

        // Restore $_POST data.
		$_POST = $post_data;

        // If errors were thrown, we need to abort.
		NoticeHandler::convert_notices_to_exceptions('woocommerce_rest_payment_error');

		// Handle result.
		$result->set_status( isset( $gateway_result['result'] ) && 'success' === $gateway_result['result'] ? 'success' : 'failure' );

		// set payment_details from result.
		$result->set_payment_details( array_merge( $result->payment_details, $gateway_result ) );
		$result->set_redirect_url( $gateway_result['redirect'] );
	}
}

RestProcessPayment::instance();
