var Helper = (function () {
    function Helper() {
    }
    Helper.viewport = function () {
        var view = { width: 0, height: 0 };
        if ('innerWidth' in window) {
            view.width = window.innerWidth;
            view.height = window.innerHeight;
        }
        else if (typeof document.documentElement !== 'undefined') {
            view.width = document.documentElement.clientWidth;
            view.height = document.documentElement.clientHeight;
        }
        else if (typeof document.body !== 'undefined') {
            view.width = document.body.clientWidth;
            view.height = document.body.clientHeight;
        }
        else if (typeof screen !== 'undefined') {
            view.width = typeof screen.availWidth !== 'undefined' ? screen.availWidth : screen.width;
            view.height = typeof screen.availHeight !== 'undefined' ? screen.availHeight : screen.height;
        }
        return view;
    };
    Helper.isMobile = function () {
        var check = false;
        (function (a) { if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4)))
            check = true; })(navigator.userAgent || navigator.vendor);
        return check;
    };
    Helper.isiOS = function () {
        var iDevices = [
            'iPad Simulator',
            'iPhone Simulator',
            'iPod Simulator',
            'iPad',
            'iPhone',
            'iPod'
        ];
        if (!!navigator.platform) {
            while (iDevices.length) {
                if (navigator.platform === iDevices.pop()) {
                    return true;
                }
            }
        }
        return false;
    };
    Helper.createCookie = function (name, value, days) {
        var expires = "";
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = "; expires=" + date.toUTCString();
        }
        document.cookie = name + "=" + value + expires + "; path=/";
    };
    Helper.readCookie = function (name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ')
                c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) === 0)
                return c.substring(nameEQ.length, c.length);
        }
        return null;
    };
    Helper.eraseCookie = function (name) {
        this.createCookie(name, "", -1);
    };
    Helper.validObject = function (obj) {
        return typeof obj !== 'undefined' && obj !== null;
    };
    Helper.validString = function (str) {
        return this.validObject(str) && typeof str.trim !== 'undefined' && str.trim().length > 0;
    };
    Helper.validArray = function (arr) {
        return this.validObject(arr) && typeof arr.length !== 'undefined' && arr.length > 0;
    };
    Helper.validElement = function (elem) {
        return this.validObject(elem) && typeof elem.length !== 'undefined' && elem.length > 0;
    };
    return Helper;
}());
var Cookie = (function () {
    function Cookie(name) {
        this.name = name;
    }
    Cookie.prototype.read = function () {
        var result = new RegExp('(?:^|; )' + encodeURIComponent(this.name) + '=([^;]*)').exec(document.cookie);
        return result ? result[1] : null;
    };
    Cookie.prototype.write = function (value, days) {
        if (!days) {
            days = 365;
        }
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        var expires = "; expires=" + date.toUTCString();
        var str = this.name + '=' + value + expires + "; path=/";
        document.cookie = this.name + '=' + value + expires + "; path=/";
    };
    Cookie.prototype.remove = function () {
        this.write("", -1);
    };
    return Cookie;
}());
var CookieList = (function () {
    function CookieList(name) {
        this.cookie = new Cookie(name);
        var value = this.cookie.read();
        this.items = value ? value.split(/,/) : new Array();
    }
    CookieList.prototype.add = function (value) {
        if (this.items.indexOf(value) >= 0) {
            return;
        }
        this.items.push(value);
        this.update();
    };
    CookieList.prototype.remove = function (value) {
        var index = this.items.indexOf(value);
        if (index != -1) {
            this.items.splice(index, 1);
        }
        this.update();
    };
    CookieList.prototype.clear = function () {
        this.items.length = 0;
        this.update();
    };
    CookieList.prototype.getItems = function () {
        return this.items;
    };
    CookieList.prototype.update = function () {
        if (this.items == null || this.items.length <= 0) {
            this.cookie.remove();
        }
        else {
            this.cookie.write(this.items.join(','));
        }
    };
    return CookieList;
}());
var QLessAppointments = (function () {
    function QLessAppointments($) {
        if ($ === void 0) { $ = jQuery; }
        var _this = this;
        this.fadeDuration = 250;
        this.fadeOffset = 125;
        this.form = $('form.qless-form.qless-form-appointments');
        if (!Helper.validElement(this.form))
            return;
        this.results = $('ul.qless-results');
        if (!Helper.validElement(this.form))
            return;
        this.cookie_authentication = new Cookie('au');
        this.cookie_identity = new Cookie('i');
        this.cookie_authentication.remove();
        this.cookie_identity.remove();
        this.form.find('input[type="radio"][name="qless_input"]').on('click', function () { return _this.updateInputSelector($); });
        this.updateInputSelector($);
        this.form.find('[type="submit"]').on('click', function (e) { return _this.submitForm(e, $); });
    }
    QLessAppointments.prototype.updateInputSelector = function ($) {
        if ($ === void 0) { $ = jQuery; }
        var selected = this.form.find('input[type="radio"][name="qless_input"]:checked, input[type="hidden"][name="qless_input"]');
        if (!Helper.validElement(selected))
            return false;
        var inputOptions = selected.attr('data-input');
        if (!Helper.validString(inputOptions))
            return false;
        inputOptions = inputOptions.split(',');
        var inputs = $();
        for (var i = 0; i < inputOptions.length; i++) {
            var input = this.form.find('input[name="' + inputOptions[i] + '"]');
            if (!Helper.validElement(input))
                continue;
            inputs = inputs.add(input);
        }
        if (!Helper.validElement)
            return false;
        return this.setInputs(inputs);
    };
    QLessAppointments.prototype.setInputs = function (inputs, $) {
        if ($ === void 0) { $ = jQuery; }
        this.form.find('ul.qless-fields > li.qless-field').removeClass('qless-field-hidden').filter(function (i, li) {
            return !$(li).hasClass('qless-field-input') && !$(li).is(inputs.closest('li.qless-field'));
        }).addClass('qless-field-hidden');
        return true;
    };
    QLessAppointments.prototype.submitForm = function (e, $) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        e.preventDefault();
        if (this.busy == true)
            return;
        this.startAjax();
        this.authenticate($)
            .then(function () { return __this.getAppointments($); })
            .then(function (data) { return __this.buildAppointments(data, $); })
            .then(function () {
            __this.stopAjax();
        }).fail(function () {
            console.log('Unable to search');
            __this.stopAjax();
        });
    };
    QLessAppointments.prototype.startAjax = function () {
        this.busy = true;
        this.results.addClass('qless-results-ajax');
        this.results.empty();
    };
    QLessAppointments.prototype.stopAjax = function () {
        this.results.removeClass('qless-results-ajax');
        this.busy = false;
    };
    QLessAppointments.prototype.buildAjaxData = function (action) {
        var formData = this.form.serializeArray();
        var ajaxData = {
            'action': action,
        };
        for (var i = 0; i < formData.length; i++) {
            ajaxData[formData[i].name] = formData[i].value;
        }
        return ajaxData;
    };
    QLessAppointments.prototype.getHost = function (uri) {
        var parser = document.createElement('a');
        parser.href = uri;
        return parser.hostname;
    };
    QLessAppointments.prototype.authenticate = function ($) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = jQuery.Deferred();
        if (Helper.validString(this.cookie_authentication.read()) && Helper.validString(this.cookie_identity.read())) {
            setTimeout(function () { d.resolve(); }, 1);
            return d.promise();
        }
        this.ajaxRequest('authenticate', false, 'response', $).done(function (response) {
            d.resolve(true);
        }).fail(function () {
            d.resolve(false);
        });
        return d.promise();
    };
    QLessAppointments.prototype.wssid = function ($) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = jQuery.Deferred();
        this.qlessRequest('api/v1/wssid', false, false, 'xml', $).done(function (wssid) {
            if (Helper.validObject(wssid)) {
                d.resolve(wssid);
            }
            else {
                d.resolve(false);
            }
        });
        return d.promise();
    };
    QLessAppointments.prototype.getAppointments = function ($) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = jQuery.Deferred();
        this.ajaxRequest('get_appointments', false, 'json', $).done(function (data) {
            d.resolve(data);
        }).fail(function () {
            d.resolve(false);
        });
        return d.promise();
    };
    QLessAppointments.prototype.buildAppointments = function (data, $) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = jQuery.Deferred();
        this.ajaxRequest('build_appointments', { 'appointments': data }, 'html', $)
            .then(function (data) {
            var items = $(data);
            var $items = $();
            items.each(function (i) {
                if (this.nodeType != 3) {
                    $items = $items.add($(this));
                }
            });
            return $items;
        }).then(function (items) { return __this.addResults(items, $); })
            .then(function (success) {
            d.resolve(success);
        }).fail(function () {
            console.log('Unable to build results.');
            d.resolve(false);
        });
        return d.promise();
    };
    QLessAppointments.prototype.buildError = function (message, $) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = jQuery.Deferred();
        this.ajaxRequest('build_error', { 'message': message }, 'html', $)
            .then(function (data) {
            var items = $(data);
            var $items = $();
            items.each(function (i) {
                if (this.nodeType != 3) {
                    $items = $items.add($(this));
                }
            });
            return $items;
        }).then(function (items) { return __this.addResults(items, $); })
            .then(function (success) {
            d.resolve(success);
        }).fail(function () {
            console.log('Unable to create error message result.');
            d.resolve(false);
        });
        return d.promise();
    };
    QLessAppointments.prototype.addResults = function (items, $) {
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = $.Deferred();
        items.css({
            'opacity': 0,
            'visibility': 'hidden',
        });
        this.results.append(items);
        items.each(function (i) {
            $(this).css('visibility', 'visible').animate({
                'opacity': 1,
            }, __this.fadeDuration + i * __this.fadeOffset, 'swing', function () {
                if (i >= items.length - 1)
                    d.resolve(true);
            });
        });
        return d.promise();
    };
    QLessAppointments.prototype.request = function (uri, data, post, type, $) {
        if (post === void 0) { post = false; }
        if (type === void 0) { type = 'json'; }
        if ($ === void 0) { $ = jQuery; }
        var __this = this;
        var d = jQuery.Deferred();
        var settings = {
            mode: 'cors',
            cache: 'no-cache',
            credentials: 'include',
            headers: new Headers({
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
                'Host': this.getHost(uri),
                'Accept': '*/*',
            }),
            redirect: 'manual',
            referrer: 'client',
        };
        if (post == true) {
            settings.method = 'POST';
            settings.body = $.param(data);
            settings.headers.append('Content-Length', settings.body.length.toString());
        }
        else {
            settings.method = 'GET';
            uri += '?' + $.param(data);
        }
        switch (type) {
            case 'json':
                fetch(uri, settings)
                    .then(function (response) { return response.text(); })
                    .then(function (text) { return $.parseJSON(text); })
                    .then(function (data) {
                    d.resolve(data);
                }).catch(function (error) {
                    console.log('Request failed', error);
                    d.resolve(false);
                });
                break;
            case 'xml':
                fetch(uri, settings)
                    .then(function (response) { return response.text(); })
                    .then(function (text) { return $.parseXML(text); })
                    .then(function (data) {
                    d.resolve(data);
                }).catch(function (error) {
                    console.log('Request failed', error);
                    d.resolve(false);
                });
                break;
            case 'text':
            case 'html':
                fetch(uri, settings)
                    .then(function (response) { return response.text(); })
                    .then(function (text) {
                    d.resolve(text);
                }).catch(function (error) {
                    console.log('Request failed', error);
                    d.resolve(false);
                });
                break;
            default:
                fetch(uri, settings)
                    .then(function (response) {
                    d.resolve(response);
                }).catch(function (error) {
                    console.log('Request failed', error);
                    d.resolve(false);
                });
                break;
        }
        return d.promise();
    };
    QLessAppointments.prototype.ajaxRequest = function (action, data, type, $) {
        if (data === void 0) { data = false; }
        if (type === void 0) { type = 'json'; }
        if ($ === void 0) { $ = jQuery; }
        var requestData = this.buildAjaxData('qless/' + action);
        if (Helper.validObject(data) && typeof data !== 'boolean') {
            for (var key in data) {
                requestData[key] = data[key];
            }
        }
        return this.request(qless.ajaxurl, requestData, true, type, $);
    };
    QLessAppointments.prototype.qlessRequest = function (endpoint, data, post, type, $) {
        if (post === void 0) { post = false; }
        if (type === void 0) { type = 'xml'; }
        if ($ === void 0) { $ = jQuery; }
        return this.request(qless.api_uri + '/' + endpoint, data, post, type, $);
    };
    return QLessAppointments;
}());
(function ($) {
    $(document).ready(function () {
        new QLessAppointments($);
    });
})(jQuery);
