<?php
/*
Plugin Name: FareHarbor for WordPress - API Sync
Plugin URI: https://plugins.cleverogre.com/plugin/fareharbor-api/
Description: Add items synchronization and other features utilizing an API connection to FareHarbor. Built as an extension to the "FareHarbor for WordPress" plugin.
Version: 0.1.0
Author: CleverOgre
Author URI: https://cleverogre.com/
Icon1x: https://plugins.cleverogre.com/plugin/fareharbor-api/?asset=icon-sm
Icon2x: https://plugins.cleverogre.com/plugin/fareharbor-api/?asset=icon
BannerHigh: https://plugins.cleverogre.com/plugin/fareharbor-api/?asset=banner
BannerLow: https://plugins.cleverogre.com/plugin/fareharbor-api/?asset=banner-sm
Text Domain: fareharbor-api
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright: © 2022 CleverOgre, Inc. All rights reserved.
*/

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

define('GFMJ_ADDON_VERSION', '0.1.1');

class Plugin {

    public static function init() {
        // Initialize Settings
        $path = self::get_path();

        // Setup Plugin Updates
        include_once($path . 'lib/wp-package-updater/class-wp-package-updater.php'); // Include private plugin updating library
        $package_updater = new \WP_Package_Updater(
            'https://plugins.cleverogre.com',
            wp_normalize_path(__FILE__),
            wp_normalize_path(plugin_dir_path(__FILE__)),
            false // License key not necessary
        );

        // Set Text Domain
        load_plugin_textdomain('fareharbor-api', false, plugin_basename(dirname(__FILE__)) . '/lang');

        // Requirements Check
        add_action('plugins_loaded', [__CLASS__, 'requirements_check'], 1, 0);

        // Delay loading
        add_action('gform_loaded', [__CLASS__, 'load'], 5, 0);
    }

    private static $requirements;
    static function requirements_check() {
        // Check for plugin requirements
        self::$requirements = [
            'ogrecore' => [
                'name' => __('OgreCore', 'fareharbor-api'),
                'url' => 'https://plugins.cleverogre.com/plugin/ogrecore/',
                'valid' => (function_exists('is_plugin_active') && is_plugin_active('OgreCore/ogrecore.php')) || class_exists('\OgreCore\Plugin'),
            ],
            'fareharbor' => [
                'name' => __('FareHarbor for WordPress', 'fareharbor-api'),
                'url' => 'https://wordpress.org/plugins/fareharbor/',
                'valid' => function_exists('is_plugin_active') && is_plugin_active('fareharbor/fareharbor.php'),
            ],
        ];

        $invalid = false;
        foreach (self::$requirements as $key => $data) {
            if (!!$data['valid']) continue;

            add_action('admin_notices', function () use ($data) {
                $message = sprintf(
                    __('In order to use the %1$s plugin, it is required that you install and activate the %3$s plugin. You can do this on the <a href="%2$s">plugins</a> page when logged in as an administrator. To download this plugin, visit the <a href="%4$s" target="_blank">%3$s website</a>.', 'fareharbor-api'),
                    get_plugin_data(__FILE__)['Name'],
                    esc_url(admin_url('plugins.php')),
                    esc_html($data['name']),
                    esc_url($data['url'])
                );
                printf('<div class="%s"><p>%s</p></div>', esc_attr('notice notice-error'), wpautop(wp_kses_post($message)));
            });

            $invalid = true;
        }

        if (!!$invalid) remove_action('gform_loaded', [__CLASS__, 'load'], 5, 0);
    }

    static function load() {
        include_once(self::get_path() . 'inc/settings.php');
        include_once(self::get_path() . 'inc/api.php');
        include_once(self::get_path() . 'inc/shortcodes.php');
        include_once(self::get_path() . 'inc/item.php');
        include_once(self::get_path() . 'inc/meta.php');
        include_once(self::get_path() . 'inc/template.php');
        include_once(self::get_path() . 'inc/sync.php');
        include_once(self::get_path() . 'inc/public-functions.php');
    }

    // Plugin File Operations

    public static function get_path($file = __FILE__) {
        return trailingslashit(dirname($file));
    }
    public static function get_dir($file = __FILE__) {
        $dir = trailingslashit(dirname($file));
        $count = 0;

        // Sanitize for Win32 installs
        $dir = str_replace('\\', '/', $dir);

        // If file is in plugins folder
        $wp_plugin_dir = str_replace('\\', '/', WP_PLUGIN_DIR);
        $dir = str_replace($wp_plugin_dir, plugins_url(), $dir, $count);

        if ($count < 1) {
            // If file is in wp-content folder
            $wp_content_dir = str_replace('\\', '/', WP_CONTENT_DIR);
            $dir = str_replace($wp_content_dir, content_url(), $dir, $count);
        }

        if ($count < 1) {
            // If file is in ??? folder
            $wp_dir = str_replace('\\', '/', ABSPATH);
            $dir = str_replace($wp_dir, site_url('/'), $dir);
        }

        return $dir;
    }
    public static function get_hook($file = __FILE__) {
        return basename(dirname($file)) . '/' . basename($file);
    }

}

Plugin::init();
