<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

define('FH_API_COMPANIES', 'companies');
define('FH_API_ITEMS', 'items');

class Api {

    // Settings

    public static function get_app_key() {
        return Settings::get_option('fh_api_app_key');
    }
    public static function get_user_key() {
        return Settings::get_option('fh_api_user_key');
    }
    public static function get_root_url() {
        return Settings::get_option('fh_api_root_url', 'https://fareharbor.com/api/external/v1');
    }

    // Methods

    private static function get_url() {
        $url = trailingslashit(self::get_root_url());
        foreach (func_get_args() as $arg) {
            $url .= trailingslashit(sanitize_title($arg));
        }
        return $url;
    }
    private static function get_header() {
        $app_key = self::get_app_key();
        $user_key = self::get_user_key();
        if (empty($app_key) || empty($user_key)) return false;
        return [
            'X-FareHarbor-API-App' => $app_key,
            'X-FareHarbor-API-User' => $user_key,
        ];
    }
    private static function get() {
        $url = self::get_url();
        if (func_num_args() > 0) $url = call_user_func_array([__CLASS__, 'get_url'], func_get_args());

        $header = self::get_header();
        if (empty($header)) return false;

        // Curl Version
        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_HTTPHEADER, $header);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($conn);
        curl_close($conn);
        if (empty($response)) return false;
        return json_decode($response, true);
    }
    private static function post($data) {
        $url = self::get_url();
        if (func_num_args() > 1) {
            $args = array_slice(func_get_args(), 1);
            $url = call_user_func_array([__CLASS__, 'get_url'], $args);
        }

        $header = self::get_header();
        if (empty($header)) return false;

        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_POST, 1);
        if (!empty($data)) curl_setopt($conn, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($conn, CURLOPT_HTTPHEADER, $header);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($conn);
        curl_close($conn);
        if (empty($response)) return false;

        // Parse json response
        return json_decode($response, true);
    }

    // Requests

    public static function get_companies() {
        $response = self::get(FH_API_COMPANIES);
        return is_array($response) && isset($response['companies']) ? $response['companies'] : false;
    }

    public static function get_items($shortname) {
        $response = self::get(FH_API_COMPANIES, $shortname, FH_API_ITEMS);
        return is_array($response) && isset($response['items']) ? $response['items'] : false;
    }

}
