<?php
/**
 * @package CleverOgre
 * @subpackage learndash-certificates-phpword
 * @version 0.1.0
 * @since 0.1.0
 */

namespace LearnDash\Certificate\PhpWord;

defined('ABSPATH') || exit;

class TemplateValues {
    use Singleton;

    public function __construct() { }

    public function get(string $key, $user_id = false, $course_id = false) {
        if (!function_exists('learndash_courseinfo')) return false;
        if (!$this->is_available($key)) return false;
        $atts = apply_filters('learndash_certificate_template_courseinfo_atts', [
            'show' => $key,
            'user_id' => $user_id,
            'course_id' => $course_id,
        ], $key, $user_id, $course_id);
        return learndash_courseinfo($atts);
    }

    public function get_all($user_id = false, $course_id = false, bool $format = true) {
        $values = [];
        foreach ($this->get_available_keys() as $key) {
            $placeholder_key = !!$format ? $this->format_key($key) : $key;
            $values[$placeholder_key] = $this->get($key, $user_id, $course_id);
        }
        return $values;
    }

    public function format_key(string $key) {
        return apply_filters('learndash_certificate_template_format_key', sprintf('{%s}', $key), $key);
    }

    public function is_available(string $key):bool {
        return in_array($key, $this->get_available_keys());
    }

    public function get_available(bool $format = false):array {
        $available = apply_filters('learndash_available_certificate_template_values', [
            'course_title' => __('Course title', Plugin::get_textdomain()),
            'course_points' => __('Total available points for the course', Plugin::get_textdomain()),
            'user_course_points' => __('Amount of points the user earned for the course', Plugin::get_textdomain()),
            'completed_on' => __('Date the course was completed', Plugin::get_textdomain()),
            'cumulative_score' => __('Average score for all graded parts of the course', Plugin::get_textdomain()),
            'cumulative_points' => __('Average points earned', Plugin::get_textdomain()),
            //'cumulative_total_points' => __('The average points earned', Plugin::get_textdomain()),
            'cumulative_percentage' => __('Average percentage of all quizzes taken in the course', Plugin::get_textdomain()),
            'cumulative_timespent' => __('Average time spent on each part of the course', Plugin::get_textdomain()),
            'aggregate_score' => __('Final score received for the course', Plugin::get_textdomain()),
            'aggregate_points' => __('Total points earned for the course', Plugin::get_textdomain()),
            //'aggregate_total_points' => __('Total points earned for the course', Plugin::get_textdomain()),
            'aggregate_percentage' => __('Total percentage score for all quizzes taken as part of the course', Plugin::get_textdomain()),
            'aggregate_timespent' => __('Total time spent on the entire course as a whole', Plugin::get_textdomain()),
        ]);
        if (!!$format) {
            $available = array_flip($available);
            $available = array_map([$this, 'format_key'], $available);
            $available = array_flip($available);
        }
        return $available;
    }
    public function get_available_keys(bool $format = false):array {
        return array_keys($this->get_available($format));
    }

}
