<?php
/**
 * @package CleverOgre
 * @subpackage woocommerce-download-template
 * @version 0.1.0
 * @since 0.1.0
 */

namespace WooCommerce\DownloadTemplate\Admin;

use WooCommerce\DownloadTemplate\Plugin;
use WooCommerce\DownloadTemplate\MetaBox;
use WooCommerce\DownloadTemplate\Product;
use WooCommerce\DownloadTemplate\Values;

defined('ABSPATH') || exit;

class Placeholders extends MetaBox {

    public function __construct() {
        parent::__construct('documents', __('Download Template Placeholders', Plugin::get_textdomain()));
    }

    protected function valid():bool {
        return Product::is();
    }

    public function render() {
        $values = Values::instance()->get_example();
?>
<table class="widefat widefat-small" cellspacing="0" style="border:0px;">
    <thead>
        <tr>
            <th style="50%"><?php esc_html_e('Placeholder', Plugin::get_textdomain()); ?></th>
            <th><?php esc_html_e('Example', Plugin::get_textdomain()); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($values as $key => $label) { ?>
        <tr>
            <td><?php echo esc_html(sprintf('${%s}', $key)); ?></td>
            <td><?php echo esc_html($label); ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<style>
.postbox table.widefat-small {
    width: calc(100% + 24px);
    max-width: none;
    margin-left: -12px;
    margin-right: -12px;
    margin-top: -6px;
    table-layout: fixed;
}
.postbox table.widefat-small th,
.postbox table.widefat-small td {
    width: 50%;
}
.postbox table.widefat-small td {
    font-size: 12px;
    white-space: normal;
    text-overflow: ellipsis;
    overflow: hidden;
}
</style>
<?php
    }

}

Placeholders::instance();
