/**
 * @package WooCommerce
 * @subpackage NewtekGateway
 * @version 1.2.0
 * @since 1.2.0
 */

// External
import { createRef, Component } from 'react';
import { __ } from '@wordpress/i18n';
import { ValidatedTextInput } from '@woocommerce/blocks-checkout';

// Internal
import { PAYMENT_METHOD_NAME, PAYMENT_METHOD_ID, PAYMENT_METHOD_TEXTDOMAIN } from './constants.js';

// Fields

export default class Fields extends Component {
    constructor(props) {
        super(props);
        this.state = {
            number: '',
            expiry: '',
            cvc: ''
        };
    }
    render() {
        return (
            <div class="wc-block-components-payment-form">
                <ValidatedTextInput
                    key="number"
                    id={ PAYMENT_METHOD_ID + '-card-number' }
                    label={ __('Card number', PAYMENT_METHOD_TEXTDOMAIN) }

                    required={ true }
                    errorId={ 'ccNumber' }

                    value={ this.state.number }
                    onChange={ (value) => this.setState({ number: value }) }

                    inputmode="numeric"
                    autocomplete="card-number"
                    autocorrect="no"
                    autocapitalize="no"
                    spellcheck="no"
                    type="tel"

                    className={ "wc-block-components-payment-form__card-number" }
                />
                <ValidatedTextInput
                    key="expiry"
                    id={ PAYMENT_METHOD_ID + '-card-expiry' }
                    label={ __('Expiry (MM/YY)', PAYMENT_METHOD_TEXTDOMAIN) }

                    required={ true }
                    errorId={ 'ccExpiry' }

                    value={ this.state.expiry }
                    onChange={ (value) => this.setState({ expiry: value }) }

                    inputmode="numeric"
                    autocomplete="cc-exp"
                    autocorrect="no"
                    autocapitalize="no"
                    spellcheck="no"
                    type="tel"

                    className={ "wc-block-components-payment-form__card-expiry" }
                />
                <ValidatedTextInput
                    key="cvc"
                    id={ PAYMENT_METHOD_ID + '-card-cvc' }
                    label={ __('Card code', PAYMENT_METHOD_TEXTDOMAIN) }

                    required={ true }
                    errorId={ 'ccCvc' }

                    value={ this.state.cvc }
                    onChange={ (value) => this.setState({ cvc: value }) }

                    inputmode="numeric"
                    autocomplete="off"
                    autocorrect="no"
                    autocapitalize="no"
                    spellcheck="no"
                    type="tel"
                    maxlength="4"

                    className={ "wc-block-components-payment-form__card-cvc" }
                />
            </div>
        );
    }
}

/*
export const Fields = (props) => {
    const { number, expiry, cvc } = props;

    return (
        <div class="wc-block-components-payment-form">
            <ValidatedTextInput
                key="number"
                id={ PAYMENT_METHOD_ID + '-card-number' }
                label={ __('Card number', PAYMENT_METHOD_TEXTDOMAIN) }

                required={ true }
                errorId={ 'ccNumber' }

                value={ number }
                onChange={ (value) => setNumber(value) }

                inputmode="numeric"
                autocomplete="card-number"
                autocorrect="no"
                autocapitalize="no"
                spellcheck="no"
                type="tel"

                className={ "wc-block-components-payment-form__card-number" }
            />
            <ValidatedTextInput
                key="expiry"
                id={ PAYMENT_METHOD_ID + '-card-expiry' }
                label={ __('Expiry (MM/YY)', PAYMENT_METHOD_TEXTDOMAIN) }

                required={ true }
                errorId={ 'ccExpiry' }

                value={ expiry }
                onChange={ (value) => setExpiry(value) }

                inputmode="numeric"
                autocomplete="cc-exp"
                autocorrect="no"
                autocapitalize="no"
                spellcheck="no"
                type="tel"

                className={ "wc-block-components-payment-form__card-expiry" }
            />
            <ValidatedTextInput
                key="cvc"
                id={ PAYMENT_METHOD_ID + '-card-cvc' }
                label={ __('Card code', PAYMENT_METHOD_TEXTDOMAIN) }

                required={ true }
                errorId={ 'ccCvc' }

                value={ cvc }
                onChange={ (value) => setCvc(value) }

                inputmode="numeric"
                autocomplete="off"
                autocorrect="no"
                autocapitalize="no"
                spellcheck="no"
                type="tel"
                maxlength="4"

                className={ "wc-block-components-payment-form__card-cvc" }
            />
        </div>
    );
};
*/
