<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

use \Ogre\FareHarbor\Meta;

$images = Meta::get_value($post_id, 'images');
if (empty($images)) return;

$classes = ['fareharbor-gallery'];
if (apply_filters('ogre/fareharbor/gallery_is_block', true, $post_id)) {
    $classes = array_merge($classes, [
        'wp-block-gallery',
        sprintf('align%s', apply_filters('ogre/fareharbor/gallery_block_align', 'default', $post_id)),
        'has-nested-images',
        sprintf('columns-%s', apply_filters('ogre/fareharbor/gallery_block_columns', 'default', $post_id)),
        sprintf('is-style-%s', apply_filters('ogre/fareharbor/gallery_block_style', 'default', $post_id)),
    ]);
    if (apply_filters('ogre/fareharbor/gallery_block_is_cropped', true)) $classes[] = 'is-cropped';
}


printf(
    '<%s class="%s">',
    apply_filters('ogre/fareharbor/gallery_wrapper_element', 'figure', $post_id),
    implode(' ', apply_filters('ogre/fareharbor/gallery_wrapper_classes', $classes, $post_id))
);

foreach ($images as $image_url) {
    $image = apply_filters('ogre/fareharbor/gallery_image_args', [
        'ID' => -1,
        'alt' => get_the_title($post_id),
        'title' => get_the_title($post_id),
        'caption' => '',
        'description' => '',
        'mime_type' => wp_check_filetype(wp_basename($image_url))['type'],
        'type' => 'image',
        'url' => $image_url,
        'width' => '',
        'height' => '',
        'sizes' => [],
    ], $image_url, $post_id);

    $classes = ['fareharbor-gallery__image'];
    if (apply_filters('ogre/fareharbor/gallery_is_block', true, $post_id)) $classes[] = 'wp-block-image';

    printf(
        '<figure class="%s">',
        implode(' ', apply_filters('ogre/fareharbor/gallery_image_classes', $classes, $image_url, $post_id))
    );
    \Ogre::the_acf_responsive_image($image, apply_filters('ogre/fareharbor/gallery_image_size', 'medium', $image_url, $post_id));
    echo '</figure>';
}

printf(
    '</%s>',
    apply_filters('ogre/fareharbor/gallery_wrapper_element', 'figure', $post_id),
);
