<?php
/**
 * @package CleverOgre
 * @subpackage WP Job Manager - JobAdder Integration
 * @since WP Job Manager - JobAdder Integration 0.1.1
 */

namespace JobAdder\API;

if (!defined('ABSPATH')) exit;

class Jobs {

    public static function getPostId(int $jobId) {
        $post_id = get_posts(array(
            'post_type' => 'job_listing',
            'post_status' => 'publish',
            'meta_query' => array(array(
                'key' => '_jobid',
                'value' => $jobId,
                'compare' => '=',
            )),
            'fields' => 'ids',
        ));
        if (is_array($post_id) && !empty($post_id)) $post_id = array_values($post_id)[0];

        return $post_id !== null && is_int($post_id) && $post_id > 0 ? $post_id : false;
    }

    public static function exists($jobId) {
        return self::getPostId($jobId) !== false;
    }

}
