<?php
/**
 * @package CleverOgre
 * @subpackage QLess
 * @since QLess 0.2.0
 */

if (!defined('ABSPATH')) exit;

if (!class_exists('QLessShortcode')) {
    class QLessShortcode {
        private $api;

        public function __construct() {
            $this->api = QLessApi();

            add_shortcode('qless-wait-times', array($this, 'wait_times'));
            //add_shortcode('qless-appointments', array($this, 'appointments'));
        }

        function wait_times($atts, $content = null) {
            $args = shortcode_atts(array(
                'ids' => '',
                'line-link' => true,
                'appt-link' => true,
                'title' => '',
                'description' => '',
                'full-description' => __('Reached Capacity', 'qless'),
            ), $atts);

            if ($content == null) {
                $content = '';
            }

            $locations = $this->api->kiosk_locations($args['ids']);
            if ($locations == false || empty($locations)) return $content;

            $html = '<div class="qless-wait-times">';

            if (!empty($args['title']) || !empty($args['description'])) {
                $html .= '<header class="qless-header">';
                if (!empty($args['title'])) {
                    $html .= '<h3 class="qless-title">' . esc_html($args['title']) . '</h3>';
                }
                if (!empty($args['description'])) {
                    $html .= '<p class="qless-description">' . esc_html($args['description']) . '</p>';
                }
                $html .= '</header>';
            }

            $html .= '<table class="qless-table">';

            $html .= '<thead><tr>';
            $html .= '<th class="location-name">' . __('Location', 'qless') . '</th>';
            $html .= '<th class="wait-time">' . __('Wait', 'qless') . '</th>';
            if ($args['line-link'] != false) {
                $html .= '<th class="line-link">' . __('Get in Line', 'qless') . '</th>';
            }
            if ($args['appt-link'] != false) {
                $html .= '<th class="appt-link">' . __('Make Appt.', 'qless') . '</th>';
            }
            $html .= '</tr></thead>';

            $html .= '<tbody>';
            foreach ($locations as $location) {
                if (!isset($location['id']) || empty($location['id'])) continue;

                $queues = $this->api->kiosk_queues($location['id']);
                if ($queues == false || empty($queues)) continue;

                $html .= '<tr id="qless-location-' . $location['id'] . '">';

                $loc_page = get_page_by_title($location['title'], OBJECT, 'location');

                $html .= '<td class="location-name">';
                if ($loc_page != null && $loc_page != false) {
                    $html .= '<a href="' . get_the_permalink($loc_page) . '" title="' . get_the_title($loc_page) . '">';
                }
                $html .= $location['title'];
                if ($loc_page != null && $loc_page != false) {
                    $html .= '</a>';
                }
                $html .= '</td>';

                $html .= '<td class="wait-times">';
                $html .= '<ul class="wait-times-list">';
                foreach ($queues as $queue) {
                    $wait = $this->api->kiosk_waitInfo($queue['id']);
                    if ($wait == false || empty($wait)) continue;
                    $wait = array_values($wait)[0];

                    $description = $wait['description'];
                    if ($description === false || empty($description)) {
                        $description = $args['full-description'];
                    }

                    $html .= '<li class="wait-times-list-item">';
                    $html .= '<span class="wait-time-title">' . $queue['title'] . '</span>';
                    $html .= '<span class="wait-time-description">' . $description . '</span>';
                    $html .= '</li>';
                }
                $html .= '</ul>';
                $html .= '</td>';

                if ($args['line-link'] != false) {
                    $html .= '<td class="line-link"><a href="https://kiosk.qless.com/kiosk/app/home/' . $location['id'] . '" target="_blank">' . __('Get in Line', 'qless') . '</a></td>';
                }

                if ($args['appt-link'] != false) {
                    $html .= '<td class="appt-link"><a href="https://kiosk.qless.com/kiosk/app/home/' . $location['id'] . '" target="_blank">' . __('Make Appointment', 'qless') . '</a></td>';
                }

                $html .= '</tr>';
            }
            $html .= '</tbody>';

            $html .= '</table>';
            $html .= '</div>';

            return $html;
        }

        function appointments($atts, $content = null) {
            $args = shortcode_atts(array(
                'ids' => '', // comma separated ids
                'actions' => 'true',
                'code' => 'true',
                'name' => 'true',
                'phone' => 'true',
                'email' => 'true',
            ), $atts);

            // Convert string to boolean
            foreach ($args as $key => $arg) {
                if ($key == 'ids') continue;
                $args[$key] = trim(strtolower($arg)) === 'true';
            }

            wp_enqueue_style('qless-appointments');
            wp_enqueue_script('jquery-mask');
            wp_enqueue_script('qless-appointments');

            $content = QLessAppointments()->form($args);

            return $content;
        }
    }

    new QLessShortcode();
}
