<?php
/*
Plugin Name: QLess Wordpress Integration
Plugin URI: http://cleverfile.net/plugins/qless/
Description: This plugin is designed to integrate with the QLess API to provide widgets and shortcodes to your site. It is developed by Clever Ogre in Pensacola, Florida.
Version: 0.2
Author: CleverOgre
Author URI: http://cleverogre.com/
Text Domain: qless
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright: CleverOgre, Inc.
           ___
          (   )
  .--.     | |    .--.       .--.        .--.
 /    \    | |   /    \    /  _  \     /  _  \
|  .-. '   | |  |  .-. ;  . .' `. ;   . .' `. ;
| |  | |   | |  |  | | |  | '   | |   | '   | |
| |  | |   | |  |  |/  |  _\_`.(___)  _\_`.(___)
| |  | |   | |  |  ' _.' (   ). '.   (   ). '.
| '  | |   | |  |  .'.-.  | |  `\ |   | |  `\ |
' `-'  |   | |  '  `-' /  ; '._,' '   ; '._,' '
 `._ / |  (___)  `.__.'    '.___.'     '.___.'
     | |
    (___)
*/

if (!defined('ABSPATH')) exit;

if (!class_exists('QLess')) {

    class QLess {
        private $settings;

        function __construct() {
            $path = $this->get_path(__FILE__);

            // Settings Classes
            include_once($path . 'core/qless.settings.php');

            // Variables
            $this->settings = new QLessSettings();
            $this->settings->name = 'QLess';
            $this->settings->version = '0.2.0';
            $this->settings->capability = 'manage_options';
            $this->settings->path = $path;
            $this->settings->dir = $this->get_dir(__FILE__);
            $this->settings->hook = basename(dirname(__FILE__)) . '/' . basename(__FILE__);

            // Setup Plugin Updates
            include_once($this->settings->path . 'inc/plugin-update-checker/plugin-update-checker.php'); // Include private plugin updating library
            $updateUrl = 'http://cleverfile.net/plugins/?' . http_build_query(array(
                'action' => 'get_metadata',
                'slug' => 'qless',
                'license_key' => $this->settings->license_key,
            ));
            $updateChecker = Puc_v4_Factory::buildUpdateChecker($updateUrl, __FILE__);

            // Set Text Domain
            load_plugin_textdomain('qless', false, plugin_basename(dirname(__FILE__)) . '/lang');

            // Filters
            add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'action_links'));

            // Core Classes
            include_once($this->settings->path . 'core/qless.api.php'); // Global Functions
            //include_once($this->settings->path . 'core/qless.ajax.php'); // General Ajax Functionality
            include_once($this->settings->path . 'core/qless.shortcode.php'); // Shortcodes
            include_once($this->settings->path . 'core/qless.widget.php'); // Widgets
            //include_once($this->settings->path . 'core/qless.appointments.php'); // Appointments Search Form
        }

        // This function will calculate the path to a file
        function get_path($file) {
            return trailingslashit(dirname($file));
        }
        // This function will calculate the directory (URL) to a file
        function get_dir($file) {
            $dir = trailingslashit(dirname($file));
            $count = 0;

            // Sanitize for Win32 installs
            $dir = str_replace('\\', '/', $dir);

            // If file is in plugins folder
            $wp_plugin_dir = str_replace('\\', '/', WP_PLUGIN_DIR);
            $dir = str_replace($wp_plugin_dir, plugins_url(), $dir, $count);

            if ($count < 1) {
                // If file is in wp-content folder
                $wp_content_dir = str_replace('\\', '/', WP_CONTENT_DIR);
                $dir = str_replace($wp_content_dir, content_url(), $dir, $count);
            }

            if ($count < 1) {
                // If file is in ??? folder
                $wp_dir = str_replace('\\', '/', ABSPATH);
                $dir = str_replace($wp_dir, site_url('/'), $dir);
            }

            return $dir;
        }

        function action_links($links) {
            array_unshift($links, '<a href="' . esc_url(admin_url('options-general.php?page=qless_settings')) . '">' . __('Settings', 'qless') . '</a>');
            return $links;
        }
    }

    new QLess();
}
