<?php
/**
 * @package CleverOgre
 * @subpackage learndash-certificates-phpword
 * @version 0.1.1
 * @since 0.1.1
 */

namespace LearnDash\Certificate\PhpWord;

defined('ABSPATH') || exit;

use \Unoconv\Unoconv;

class UnoconvConverter extends Converter {

    public static function valid():bool {
        return class_exists('\Unoconv\Unoconv');
    }

    public static function get_extension():string {
        return 'pdf';
    }

    private $unoconv = null;
    function __construct() {
        parent::__construct();
    }

    protected function _convert(string $input, string $output):bool {
        if (is_null($this->unoconv) && static::valid()) $this->unoconv = Unoconv::create();
        if (is_null($this->unoconv)) return false;

        try {
            $this->unoconv->transcode($input, static::get_extension(), $output);
        } catch (Exception $e) {
            return false;
        }

        return true;
    }

}
