<?php
/**
 * @package CleverOgre
 * @subpackage learndash-certificates-phpword
 * @version 0.1.0
 * @since 0.1.0
 */

namespace LearnDash\Certificate\PhpWord;

defined('ABSPATH') || exit;

class CertificateSettings extends PostSettings {

    function __construct() {
        parent::__construct(
            'sfwd-certificates',
            Plugin::get_textdomain(),
            __('PhpWord Template Settings', Plugin::get_textdomain())
        );

        add_filter('upload_mimes', [$this, 'upload_mimes'], 10, 1);
    }

    public function upload_mimes($mime_types) {
        return array_unique(array_merge(TemplateGenerator::get_allowed_mime_types(), $mime_types));
    }

    public function register_groups():array {
        $template_group = new SettingsGroup(
            'template',
            __('Template', Plugin::get_textdomain()),
            __('Define a word or spreadsheet document template for this certificate.', Plugin::get_textdomain()),
            [
                new \OgreCore\Field\File([
                    'name' => 'ld_cert_phpword_file',
                    'title' => __('Template File', Plugin::get_textdomain()),
                    'description' => sprintf(
                        __('Upload the file that you\'d like to use for certificate. Must have one of the following file extensions: %s.', Plugin::get_textdomain()),
                        implode(', ', array_keys(TemplateGenerator::get_allowed_mime_types()))
                    ),
                    'allowed_mime_types' => TemplateGenerator::get_allowed_mime_types(),
                ]),
            ]
        );

        $values_group = new SettingsGroup(
            'values',
            __('Placeholders', Plugin::get_textdomain()),
            __('The following template placeholders can be used when building your certificate templates.', Plugin::get_textdomain()),
            [] // Fields
        );

        $values = TemplateValues::instance()->get_available(true);
        foreach ($values as $key => $value) {
            $values_group->add_field(new \OgreCore\Field\Text([
                'name' => '',
                'title' => $value,
                'default_value' => $key,
                'readonly' => true,
            ]));
        }

        return [
            $template_group,
            $values_group,
        ];
    }

    public function get_file_id($object_id = false) {
        $attachment_id = $this->get_field_value('template', 'ld_cert_phpword_file', $object_id);
        if (!is_numeric($attachment_id)) return false;
        return intval($attachment_id);
    }
    public function get_file_url($object_id = false) {
        $attachment_id = $this->get_file_id($object_id);
        if (!is_int($attachment_id)) return false;
        $attachment_url = wp_get_attachment_url($attachment_id);
        if (!is_string($attachment_url) || empty($attachment_url)) return false;
        return $attachment_url;
    }
    public function get_file_path($object_id = false) {
        $attachment_id = $this->get_file_id($object_id);
        if (!is_int($attachment_id)) return false;
        $attachment_file = get_attached_file($attachment_id);
        if (!is_string($attachment_file) || empty($attachment_file)) return false;
        return $attachment_file;
    }

}

CertificateSettings::instance();
