<?php
/**
 * @package CleverOgre
 * @subpackage woocommerce-download-template
 * @version 0.1.0
 * @since 0.1.0
 */

namespace WooCommerce\DownloadTemplate;

defined('ABSPATH') || exit;

abstract class MetaBox {
    use Singleton;

    private string $id;
    private string $title;
    private string $screen = 'product';
    private string $context = 'side';
    private string $priority = 'low';

    public function __construct(string $id, string $title) {
        $this->id = $id;
        $this->title = $title;
        add_action('add_meta_boxes', [$this, 'register']);
    }

    protected function valid():bool {
        return true;
    }

    public function register() {
        if (!$this->valid()) return;
        add_meta_box($this->id, $this->title, [$this, 'render'], $this->screen, $this->context, $this->priority);
    }

    public abstract function render();

}
