<?php
/**
 * @package CleverOgre
 * @subpackage woocommerce-download-template
 * @version 0.1.0
 * @since 0.1.0
 */

namespace WooCommerce\DownloadTemplate;

defined('ABSPATH') || exit;

class Product {
    use Singleton;

    private const META_KEY = '_download_template_enabled';

    public function __construct() {
        add_action('woocommerce_product_options_downloads', [$this, 'render_options'], 10);
        add_action('woocommerce_process_product_meta', [$this, 'update_options'], 10, 1);
        add_filter('woocommerce_is_sold_individually', [$this, 'is_sold_individually'], 10, 2);
        //add_action('woocommerce_account_downloads_column_download-product', [$this, 'product_column'], 10, 1);
        add_filter('woocommerce_download_product_filepath', [$this, 'process'], 10, 5);
    }

    public static function is(\WC_Product|\WP_Post|int|string|bool $product = false, bool $check_file = false):bool {
        if (is_bool($product) && $product === false) $product = get_the_ID();
        if (is_string($product) && is_numeric($product)) $product = intval($product);
        if (is_int($product) && function_exists('wc_get_product')) $product = wc_get_product($product);
        if (!is_object($product)) return false;
        if (is_a($product, '\WP_Post') && $product->post_type === 'product') $product = wc_get_product($product->ID);
        if (!is_a($product, '\WC_Product')) return false;
        return $product->is_downloadable() && $product->get_meta(self::META_KEY, true) === 'yes' && (!$check_file || $product->has_file());
    }

    public function render_options() {
        global $post;
        woocommerce_wp_checkbox([
            'id' => self::META_KEY,
            'label' => __('Download Template', 'woocommerce'),
            'description' => __('Process download as template?', Plugin::get_textdomain()),
        ]);
    }

    public function update_options($post_id) {
        update_post_meta($post_id, self::META_KEY, esc_attr(isset($_POST[self::META_KEY]) ? 'yes' : 'no'));
    }

    public function is_sold_individually($is, $product) {
        // TODO: Remove this once download to order item association is resolved.
        return $product->get_meta(self::META_KEY, true) === 'yes' ? true : $is;
    }

    public function product_column($download) {
        $product_name = $download['product_name'];

        // NOTE: Can't get order item id from WC_Customer_Download. Only allow single purchase per order.
        $order = wc_get_order($download['order_id']);
        $order_items = $order->get_items();
        $order_items = array_filter($order_items, function ($order_item) use ($download) {
            return $order_item->get_product_id() == $download['product_id'];
        });
        if (!empty($order_items)) {
            $order_item = current($order_items);
            // TODO: Get form data and display in product_name?
        }

        if ($download['product_url']) {
        	echo '<a href="' . esc_url($download['product_url']) . '">' . esc_html($product_name) . '</a>';
        } else {
        	echo esc_html($product_name);
        }
    }

    public function get_order_item(\WC_Order $order, \WC_Product $product):\WC_Order_Item {
        // NOTE: Can't get order item id from WC_Customer_Download. Only allow single purchase per order.
        $product_id = $product->get_id();
        $order_items = $order->get_items();
        $order_items = array_filter($order_items, function ($order_item) use ($product_id) {
            return $order_item->get_product_id() == $product_id;
        });
        if (empty($order_items)) return null;
        return current($order_items);
    }

    public function process(string $file_path, string $email_address, \WC_Order|bool $order, \WC_Product $product, \WC_Customer_Download $download):string {
        if (!$this->is($product, true)) return $filename;

        $order_item = $this->get_order_item($order, $product);
        if (is_null($order_item)) return $filename;

        $args = apply_filters('wc_download_template_download_args', [
            'user_id' => $order->get_user_id(),
            'order_id' => $order->get_id(),
            'product_id' => $product->get_id(),
        ], $order_item, $order, $product, $download);

        $tmp_file_path = Template::instance()->apply(File::instance()->get_path($file_path), $args);
        $tmp_file_path = File::instance()->convert_to_pdf($tmp_file_path);
        if (!!$tmp_file_path) $file_path = $tmp_file_path;

        return $file_path;
    }

}

Product::instance();
