<?php
/**
 * @package CleverOgre
 * @subpackage OgreModal
 * @version 0.4.2
 * @since 0.4.0
 */

namespace OgreModal;

if (!defined('ABSPATH')) exit;

class Settings {

    private static $option_key = 'ogremodal';
    private static $defaults;

    public static function init() {
        self::$defaults = array();
    }

    public static function get_option($key) {
        switch ($key) {
            default:
                $options = get_option(self::$option_key);

                if (isset($options[strval($key)])) {
                    return $options[strval($key)];
                } else if (isset(self::$defaults[$key])) {
                    return self::$defaults[$key];
                } else {
                    return false;
                }

                break;
        }

        return null;
    }

    public static function set_option($key, $value) {
        switch ($key) {
            default:
                $options = get_option(self::$option_key);
                if (!is_array($options)) $options = array();
                $options[strval($key)] = $value;
                update_option(self::$option_key, $options);
                break;
        }

        return true;
    }

    public static function get_default($key) {
        if (!array_key_exists($key, self::$defaults)) return null;
        return self::$defaults[$key];
    }

    public static function get_field($key) {
        return get_field(sprintf('%s_%s', self::$option_key, sanitize_title($key)), 'options');
    }

}
