<?php
/**
 * @package CleverOgre
 * @subpackage WP Job Manager - JobAdder Integration
 * @since WP Job Manager - JobAdder Integration 0.1.1
 */

namespace JobAdder\API;

if (!defined('ABSPATH')) exit;

class JobAds {

    public static function getAd(int $adId) {
        $url = \JobAdder\API\Utility::buildApiIdUrl(JOBADDER_JOBADS_ENDPOINT, $adId);
        if (!$url) return false;

        $data = \JobAdder\API\Utility::getJson($url);
        if (!isset($data['adId'])) return false;

        return (array)$data;
    }

    public static function getJobIdByAd(int $adId, $force = false) {
        if ($adId != null && !!($post_id = \JobAdder\API\JobAds::getPostId($adId)) && !$force) {
            $meta_value = get_post_meta($post_id, '_jobid', true);
            if (is_numeric($meta_value)) return (int)intval($meta_value);
        }

        $ad = self::getAd($adId);
        if (!$ad || !isset($ad['job'])) return false;

        $jobId = (int)$ad['job']['jobId'];

        // Update post meta
        if ($adId != null && !!$post_id) {
            update_post_meta($post_id, '_jobid', strval($jobId));
        }

        return $jobId;
    }

    public static function getPostId(int $adId) {
        $post_id = get_posts(array(
            'post_type' => 'job_listing',
            'post_status' => 'publish',
            'meta_query' => array(array(
                'key' => '_adid',
                'value' => $adId,
                'compare' => '=',
            )),
            'fields' => 'ids',
        ));
        if (is_array($post_id) && !empty($post_id)) $post_id = array_values($post_id)[0];

        return $post_id !== null && is_int($post_id) && $post_id > 0 ? $post_id : false;
    }

    public static function exists($adId) {
        return self::getPostId($adId) !== false;
    }

}
