<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

class Meta {

    private static $id;
    private static $prepend;
    private static $fields;

    private static $readonly = false;

    public static function load() {
        self::$id = 'fareharbor-meta';
        self::$prepend = 'fh_';

        add_filter('ogre/packages', [__CLASS__, 'packages'], 10, 1);
        add_action('init', [__CLASS__, 'init']);
    }

    static function packages($packages) {
        if (!in_array('field', $packages)) $packages[] = 'field';
        return $packages;
    }

    static function init() {
        if (!class_exists('\OgreCore\Field')) return;

        self::$fields = [
            'sync' => new \OgreCore\Field\Checkbox([
                'group' => self::$id,
                'name' => self::get_key('sync'),
                'title' => __('Synchronize Item with FareHarbor', 'fareharbor-api'),
                'description' => __('Synchronize this item daily with data provided by FareHarbor. Synchronization will remove any changes made to this item locally.', 'fareharbor-api'),
                'default_value' => self::$readonly,
            ]),
            'pk' => new \OgreCore\Field\Number([
                'group' => self::$id,
                'name' => self::get_key('pk'),
                'title' => __('ID', 'fareharbor-api'),
                'description' => __('The item\'s unique ID.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'name' => new \OgreCore\Field\Text([
                'group' => self::$id,
                'name' => self::get_key('name'),
                'title' => __('Name', 'fareharbor-api'),
                'description' => __('The name of the item.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'headline' => new \OgreCore\Field\Text([
                'group' => self::$id,
                'name' => self::get_key('headline'),
                'title' => __('Headline', 'fareharbor-api'),
                'description' => __('The item\'s headline.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'description' => new \OgreCore\Field\Text([
                'group' => self::$id,
                'name' => self::get_key('description'),
                'title' => __('Description', 'fareharbor-api'),
                'description' => __('The item\'s description.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'description_text' => new \OgreCore\Field\TextArea([
                'group' => self::$id,
                'name' => self::get_key('description_text'),
                'title' => __('Description (Plain-Text)', 'fareharbor-api'),
                'description' => __('The item\'s plain-text description.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'description_bullets' => new \OgreCore\Field\TextArea([
                'group' => self::$id,
                'name' => self::get_key('description_bullets'),
                'title' => __('Bullets', 'fareharbor-api'),
                'description' => __('An array containing plain-text descriptive bullet points for the item.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'cancellation_policy' => new \OgreCore\Field\Text([
                'group' => self::$id,
                'name' => self::get_key('cancellation_policy'),
                'title' => __('Cancellation Policy', 'fareharbor-api'),
                'description' => __('The item\'s cancellation policy.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'location' => new \OgreCore\Field\Text([
                'group' => self::$id,
                'name' => self::get_key('location'),
                'title' => __('Location', 'fareharbor-api'),
                'description' => __('The location of the item; generally where the activity takes place or where the tour leaves from, but can be anything. Unstructured.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'locations' => new \OgreCore\Field\Hidden([
                'group' => self::$id,
                'name' => self::get_key('locations'),
                'title' => __('Locations', 'fareharbor-api'),
                'description' => __('An array of `Location` objects associated with the item.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'is_pickup_ever_available' => new \OgreCore\Field\Checkbox([
                'group' => self::$id,
                'name' => self::get_key('is_pickup_ever_available'),
                'title' => __('Pickup Availability', 'fareharbor-api'),
                'description' => __('Indicates whether the item is configured to provide pickups.', 'fareharbor-api'),
                'default_value' => false,
                'readonly' => self::$readonly,
            ]),
            'image_cdn_url' => new \OgreCore\Field\Text([
                'group' => self::$id,
                'name' => self::get_key('image_cdn_url'),
                'title' => __('Image URL', 'fareharbor-api'),
                'description' => __('A URL to the item\'s primary image.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'images' => new \OgreCore\Field\TextArea([
                'group' => self::$id,
                'name' => self::get_key('images'),
                'title' => __('Images', 'fareharbor-api'),
                'description' => __('An array of Image objects associated with the item.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'customer_prototypes' => new \OgreCore\Field\Hidden([
                'group' => self::$id,
                'name' => self::get_key('customer_prototypes'),
                'title' => __('Customers', 'fareharbor-api'),
                'description' => __('An array of `CustomerPrototype` objects associated with the item.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
            'health_and_safety_policy' => new \OgreCore\Field\TextArea([
                'group' => self::$id,
                'name' => self::get_key('health_and_safety_policy'),
                'title' => __('Health and Safety Policy', 'fareharbor-api'),
                'description' => __('The item\'s health and safety policy. It includes details and procedures related to specific activities for the item like the precautions being taken, equipment to bring, and any additional special rules.', 'fareharbor-api'),
                'readonly' => self::$readonly,
            ]),
        ];

        add_action('add_meta_boxes', [__CLASS__, 'register']);
        add_action('save_post', [__CLASS__, 'save'], 10, 1);
    }

    static function register() {
        add_meta_box(
            self::$id,
            __('Item Data', 'fareharbor-api'),
            [__CLASS__, 'display'],
            Item::get_post_type(),
            'side',
            'default'
        );
    }

    static function display($post) {
        wp_nonce_field(self::$id . '_' . $post->ID, self::$id . '_nonce');

        foreach (self::$fields as $field) {
            $field->build($post->ID);
        }
    }

    static function save($post_id) {
        if (!isset($_POST[self::$id . '_nonce']) || !wp_verify_nonce($_POST[self::$id . '_nonce'], self::$id . '_' . $post_id)) return;

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

        if (!current_user_can('edit_post', $post_id )) return;

        foreach (self::$fields as $key => $field) {
            if ($field->get_type() == 'hidden' || !isset($_POST[$field->get_name()])) continue;

            if (in_array($key, ['description_bullets', 'images'])) {
                $field->set(array_filter(array_map('sanitize_text_field', explode(PHP_EOL, $_POST[$field->get_name()]))), $post_id);
            } else {
                $field->set(sanitize_text_field($_POST[$field->get_name()]), $post_id);
            }
        }
    }

    public static function get_key($key) {
        return sanitize_title(self::$prepend . $key);
    }
    public static function get_value($post_id, $key) {
        if (isset(self::$fields) && !empty(self::$fields)) {
            foreach (self::$fields as $_key => $field) {
                if ($_key == $key) return $field->get($post_id);
            }
            return false;
        } else {
            return get_post_meta($post_id, $key, false);
        }
    }

    public static function set_data($post_id, $data, $update = false) {
        if (!isset(self::$fields) || empty(self::$fields)) return false;
        if (get_post_type($post_id) != Item::get_post_type()) return false;

        $updated = 0;
        foreach (self::$fields as $key => $field) {
            $value = isset($data[$key]) ? $data[$key] : null;
            if ($update === false && is_null($value)) {
                $field->delete_value($post_id);
                $updated++;
            } else if (!is_null($value)) {
                $field->set($value, $post_id);
                $updated++;
            }
        }
        return $updated > 0;
    }
    public static function update_data($post_id, $data) {
        return self::set_data($post_id, $data, true);
    }

}

Meta::load();
