<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

class Settings {

    private static $options;

    private static function is_disabled() {
        return apply_filters('fareharbor/disabled', false);
    }
    private static function is_lite() {
        return apply_filters('fareharbor/lite', false);
    }

    public static function load() {
        if (self::is_disabled() || !class_exists('Fareharbor')) return;
        add_action('admin_init', [__CLASS__, 'register_settings']);
    }

    private static $fh_file;
    static function register_settings() {
        if (self::is_lite()) return;

        self::$fh_file = WP_PLUGIN_DIR . '/fareharbor/fareharbor.php';

        add_settings_section(
            'fh_api_section',
            __('FareHarbor API', 'fareharbor-api'),
            [__CLASS__, 'render_fh_api_section_text'],
            self::$fh_file
        );

        add_settings_field(
            'fh_api_app_key',
            __('App Key', 'fareharbor-api'),
            ['\Fareharbor', 'render_input_field'],
            self::$fh_file,
            'fh_api_section',
            [
                'option_name' => 'fh_api_app_key',
                'description' => __('Your app key.', 'fareharbor-api'),
            ]
        );

        add_settings_field(
            'fh_api_user_key',
            __('User Key', 'fareharbor-api'),
            ['\Fareharbor', 'render_input_field'],
            self::$fh_file,
            'fh_api_section',
            [
                'option_name' => 'fh_api_user_key',
                'description' => __('Your user key.', 'fareharbor-api'),
            ]
        );

        add_settings_field(
            'fh_api_root_url',
            __('Root Url', 'fareharbor-api'),
            ['\Fareharbor', 'render_input_field'],
            self::$fh_file,
            'fh_api_section',
            [
                'option_name' => 'fh_api_root_url',
                'description' => __('The target url for your api. Defaults to <code>https://fareharbor.com/api/external/v1</code>. Use <code>https://test.fareharbor.com/api/external/v1</code> for testing.', 'fareharbor-api'),
            ]
        );

        add_settings_field(
            'fh_api_sync_enabled',
            __('Synchronize', 'fareharbor-api'),
            ['\Fareharbor', 'render_input_field'],
            self::$fh_file,
            'fh_api_section',
            [
                'option_name' => 'fh_api_sync_enabled',
                'type' => 'checkbox',
                'label' => 'Enable FareHarbor Api Synchronization',
                'description' => __('Automatically synchronize items from FareHarbor. Runs daily via a cron event.', 'fareharbor-api'),
            ]
        );

        add_settings_field(
            'fh_api_sync_shortname',
            __('Synchronize Company', 'fareharbor-api'),
            ['\Fareharbor', 'render_input_field'],
            self::$fh_file,
            'fh_api_section',
            [
                'option_name' => 'fh_api_sync_shortname',
                'description' => __('Company shortname to synchronize from. By default, all companies that are available to the API user will be synchronized with if this setting is not defined.', 'fareharbor-api'),
            ]
        );

        do_action('ogre/fareharbor/register_settings', self::$fh_file);
    }

    static function render_fh_api_section_text() {
        echo wpautop(__('Settings for advanced Api synchronization with FareHarbor.', 'fareharbor-api'));
        do_action('ogre/fareharbor/settings_section');
    }

    public static function get_option($option_name, $default = '', $filtered = true) {
        $filter_name = str_replace( 'fh_', '', $option_name );
        $filter_name = str_replace( 'default_', 'defaults/', $filter_name );
        $filter_name = str_replace( 'buttons_', 'buttons/', $filter_name );
        $filter_name = "fareharbor/$filter_name";

        if (self::is_lite()) return $filtered ? apply_filters($filter_name, $default) : $default;

        if (!isset(self::$options)) self::$options = get_option('fareharbor_settings');

        $value = isset(self::$options[$option_name]) ? self::$options[$option_name] : $default;

        if ($filtered) $value = apply_filters($filter_name, $value);

        return $value;
    }

}

add_action('init', ['\Ogre\FareHarbor\Settings', 'load'], 11);
