<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

namespace Ogre\FareHarbor;

if (!defined('ABSPATH')) exit;

class Shortcodes {

    public static $default_flow = null;

    public static function load() {
        self::$default_flow = apply_filters('ogre/fareharbor/default_shortcode_flow', false);
        add_filter('acf/settings/load_json', [__CLASS__, 'load_json_dir'], 10, 1);
        add_filter('ogre/blocks', [__CLASS__, 'blocks'], 10, 1);
        add_filter('wp_nav_menu_items', [__CLASS__, 'menu_items'], 10, 2);
    }

    static function load_json_dir($paths) {
        $paths[] = Plugin::get_path() . 'acf-json';
        return $paths;
    }

    static function blocks($blocks) {
        $block_names = wp_list_pluck($blocks, 'name');

        if (!in_array('fareharbor-calendar', $block_names)) {
            $blocks[] = [
                'name' => 'fareharbor-calendar',
                'title' => __('FareHarbor Calendar', 'fareharbor-api'),
                'icon' => 'calendar-alt',
                'mode' => 'preview',
            ];
        }

        if (!in_array('fareharbor-itemgrid', $block_names)) {
            $blocks[] = [
                'name' => 'fareharbor-itemgrid',
                'title' => __('FareHarbor Item Grid', 'fareharbor-api'),
                'icon' => 'grid-view',
                'mode' => 'preview',
            ];
        }

        if (!in_array('fareharbor-lightframe', $block_names)) {
            $blocks[] = [
                'name' => 'fareharbor-lightframe',
                'title' => __('FareHarbor Lightframe', 'fareharbor-api'),
                'icon' => 'admin-comments',
                'mode' => 'preview',
                'align_text' => true,
                'color' => [
                    'background' => true,
                    'text' => true,
                ],
            ];
        }

        if (!in_array('fareharbor-partners', $block_names)) {
            $blocks[] = [
                'name' => 'fareharbor-partners',
                'title' => __('FareHarbor Partners', 'fareharbor-api'),
                'icon' => 'admin-users',
                'mode' => 'preview',
            ];
        }

        return $blocks;
    }

    static function menu_items($html, $args) {

        $items = wp_get_nav_menu_items($args->menu);

        foreach ($items as $item) {
            if (!get_field('fareharbor', $item)) continue;

            $attrs = [];
            if (!empty(get_field('flow', $item))) {
                $attrs['flow'] = get_field('flow', $item);
            } else if (is_int(self::$default_flow)) {
                $attrs['flow'] = self::$default_flow;
            }

            $html = preg_replace(
                sprintf('/(<li id="menu-item-%d"[^>]*>)(.*)<\/li>/m', $item->ID),
                sprintf('$1%s</li>', self::the_shortcode('lightframe', $attrs, false, $item->title)),
                $html
            );
        }

        return $html;
    }

    public static function get_shortcode_attrs($shortcode) {
        $fields = ['shortname', 'asn', 'asn_ref', 'ref', 'sheet', 'schedule', 'language', 'full_items'];
        switch ($shortcode) {
            case 'partners':
                $fields[] = 'include';
                break;
            case 'fareharbor':
                $fields[] = 'lightframe';
                break;
            case 'lightframe':
                $fields = array_merge($fields, ['class', 'view', 'view_item', 'view_availability', 'flow']);
                break;
        }

        $attrs = [];
        foreach ($fields as $key) {
            $value = get_field($key);
            if (empty($value)) continue;
            $attrs[$key] = $value;
        }

        if ($shortcode == 'lightframe' && (!isset($attrs['flow']) || empty($attrs['flow'])) && is_int(self::$default_flow)) {
            $attrs['flow'] = self::$default_flow;
        }

        return $attrs;
    }
    public static function the_shortcode_attrs($shortcode, $attrs = false, $echo = true) {
        if (!is_array($attrs)) $attrs = [];
        $attrs = array_merge(self::get_shortcode_attrs($shortcode), $attrs);

        $html = '';
        foreach ($attrs as $key => $value) {
            $html .= sprintf(' %s="%s"', sanitize_title($key), esc_attr($value));
        }
        if ($echo) {
            echo $html;
            return true;
        }  else {
            return $html;
        }
    }
    public static function the_shortcode($shortcode, $attrs = false, $echo = true, $text = '') {
        $html = sprintf('[%s%s]', sanitize_title($shortcode), self::the_shortcode_attrs($shortcode, $attrs, false));
        if (!empty($text)) $html .= sprintf('%s[/%s]', $text, sanitize_title($shortcode));
        $html = do_shortcode($html);
        if ($echo) {
            echo $html;
            return true;
        } else {
            return $html;
        }
    }

}

Shortcodes::load();
