<?php
/*
Plugin Name: Gravity Forms Matador Jobs & Bullhorn Feed
Plugin URI: https://plugins.cleverogre.com/plugin/gravityforms-matador-jobs/
Description: Add the Matador Jobs Feed to Gravity Forms.
Version: 0.1.0
Author: CleverOgre
Author URI: https://cleverogre.com/
Icon1x: https://plugins.cleverogre.com/plugin/gravityforms-matador-jobs/?asset=icon-sm
Icon2x: https://plugins.cleverogre.com/plugin/gravityforms-matador-jobs/?asset=icon
BannerHigh: https://plugins.cleverogre.com/plugin/gravityforms-matador-jobs/?asset=banner
BannerLow: https://plugins.cleverogre.com/plugin/gravityforms-matador-jobs/?asset=banner-sm
Text Domain: gravityforms-matador-jobs
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright: © 2022 CleverOgre, Inc. All rights reserved.
*/

namespace GFMatadorJobs;

if (!defined('ABSPATH')) exit;

define('GFMJ_ADDON_VERSION', '0.1.0');

class Plugin {

    public static function init() {
        // Initialize Settings
        $path = self::get_path();

        // Setup Plugin Updates
        include_once($path . 'lib/wp-package-updater/class-wp-package-updater.php'); // Include private plugin updating library
        $package_updater = new \WP_Package_Updater(
            'https://plugins.cleverogre.com',
            wp_normalize_path(__FILE__),
            wp_normalize_path(plugin_dir_path(__FILE__)),
            false // License key not necessary
        );

        // Set Text Domain
        load_plugin_textdomain('gravityforms-matador-jobs', false, plugin_basename(dirname(__FILE__)) . '/lang');

        // Requirements Check
        add_action('plugins_loaded', [__CLASS__, 'requirements_check'], 1, 0);

        // Delay loading
        add_action('gform_loaded', [__CLASS__, 'load'], 5, 0);
    }

    private static $requirements;
    static function requirements_check() {
        // Check for plugin requirements
        self::$requirements = [
            'gravityforms' => [
                'name' => __('Advanced Custom Fields Pro', 'gravityforms-matador-jobs'),
                'url' => 'https://www.advancedcustomfields.com/',
                'valid' => (function_exists('is_plugin_active') && is_plugin_active('advanced-custom-fields-pro/acf.php')) || class_exists('\ACF'),
            ],
            'matador-jobs-pro' => [
                'name' => __('Matador Jobs Pro', 'gravityforms-matador-jobs'),
                'url' => 'https://matadorjobs.com/',
                'valid' => function_exists('is_plugin_active') && is_plugin_active('matador-jobs-pro/matador.php'),
            ],
        ];

        $invalid = false;
        foreach (self::$requirements as $key => $data) {
            if (!!$data['valid']) continue;

            add_action('admin_notices', function () use ($data) {
                $message = sprintf(
                    __('In order to use the %1$s plugin, it is required that you install and activate the %3$s plugin. You can do this on the <a href="%2$s">plugins</a> page when logged in as an administrator. To download this plugin, visit the <a href="%4$s" target="_blank">%3$s website</a>.', 'gravityforms-matador-jobs'),
                    get_plugin_data(__FILE__)['Name'],
                    esc_url(admin_url('plugins.php')),
                    esc_html($data['name']),
                    esc_url($data['url'])
                );
                printf('<div class="%s"><p>%s</p></div>', esc_attr('notice notice-error'), wpautop(wp_kses_post($message)));
            });

            $invalid = true;
        }

        if (!!$invalid) remove_action('gform_loaded', [__CLASS__, 'load'], 5, 0);
    }

    static function load() {
        if (!method_exists('\GFForms', 'include_feed_addon_framework')) return;

        \GFForms::include_feed_addon_framework();
        include_once(self::get_path() . 'inc/class-gfmatadoraddon.php');
        \GFAddOn::register('\GFMatadorJobs\Feed');

        include_once(self::get_path() . 'inc/field-population.php');
    }

    // Plugin File Path Calculations

    public static function get_path($file = __FILE__) {
        return trailingslashit(dirname($file));
    }
    public static function get_dir($file = __FILE__) {
        $dir = trailingslashit(dirname($file));
        $count = 0;

        // Sanitize for Win32 installs
        $dir = str_replace('\\', '/', $dir);

        // If file is in plugins folder
        $wp_plugin_dir = str_replace('\\', '/', WP_PLUGIN_DIR);
        $dir = str_replace($wp_plugin_dir, plugins_url(), $dir, $count);

        if ($count < 1) {
            // If file is in wp-content folder
            $wp_content_dir = str_replace('\\', '/', WP_CONTENT_DIR);
            $dir = str_replace($wp_content_dir, content_url(), $dir, $count);
        }

        if ($count < 1) {
            // If file is in ??? folder
            $wp_dir = str_replace('\\', '/', ABSPATH);
            $dir = str_replace($wp_dir, site_url('/'), $dir);
        }

        return $dir;
    }
    public static function get_hook($file = __FILE__) {
        return basename(dirname($file)) . '/' . basename($file);
    }

}

\GFMatadorJobs\Plugin::init();
