<?php
/**
 * @package CleverOgre
 * @subpackage GFMatadorJobs
 * @since 0.1.0
 * @version 0.1.0
 */

namespace GFMatadorJobs;

use \matador\Matador;
use \matador\Template_Support;

if (!defined('ABSPATH')) exit;

class FieldPopulation {

    public static function load() {
        add_filter('gform_pre_render', [__CLASS__, 'populate_listings'], 10, 1);
        add_filter('gform_pre_validation', [__CLASS__, 'populate_listings'], 10, 1);
        add_filter('gform_pre_submission_filter', [__CLASS__, 'populate_listings'], 10, 1);
        add_filter('gform_admin_pre_render', [__CLASS__, 'populate_listings'], 10, 1);
    }

    private static $choices = null;
    static function populate_listings($form) {
        foreach ($form['fields'] as &$field) {
            if (!in_array($field->type, ['select', 'multiselect']) || !$field->allowsPrepopulate || $field->inputName != Matador::variable('post_type_key_job_listing')) continue;

            if (is_null(self::$choices)) self::$choices = self::get_job_listing_choices();
            $field->choices = self::$choices;
        }
        return $form;
    }

    private static function get_job_listings() {
        return get_posts([
            'post_type' => Matador::variable('post_type_key_job_listing'),
            'posts_per_page' => -1,
            'status' => 'publish',
        ]);
    }
    private static function get_job_listing_choices() {
        $posts = self::get_job_listings();
        if (empty($posts)) return false;

        $choices = [];
        foreach ($posts as $_post) {
            $choices[] = [
                'text' => self::get_job_listing_label($_post),
                'value' => $_post->ID,
            ];
        }
        return $choices;
    }
    private static function get_job_listing_label($_post) {
        $location = (string)get_post_meta($_post->ID, 'job_general_location', true);
        if (!empty($location)) {
            return sprintf(
                __('Job #%s: %s in %s'),
                (string)get_post_meta($_post->ID, 'bullhorn_job_id', true),
                $_post->post_title,
                (string)get_post_meta($_post->ID, 'job_general_location', true)
            );
        } else {
            return sprintf(
                __('Job #%s: %s'),
                (string)get_post_meta($_post->ID, 'bullhorn_job_id', true),
                $_post->post_title
            );
        }
    }

}

FieldPopulation::load();
