<?php
/**
 * @package CleverOgre
 * @subpackage OgreSchema
 * @version 0.1.0
 * @since 0.1.0
 */

namespace OgreSchema;

if (!defined('ABSPATH')) exit;

class Output {
    use Singleton;

    public function __construct() {
        add_action('wp_footer', [$this, 'render']);
    }

    // Add JSON to Footer
    public function render() {
        if (!Data::has_schema()) return;
        printf(
            '<script type="application/ld+json">%s</script>',
            json_encode(Data::get_schema()) // NOTE: esc_js()?
        );
    }

}

Output::instance();
