<?php
/**
 * @package CleverOgre
 * @subpackage OgreSchema
 * @version 0.1.0
 * @since 0.1.0
 */

namespace OgreSchema;

if (!defined('ABSPATH')) exit;

class Settings {
    use Singleton;

    private const PARENT_SLUG = 'options-general.php';

    private array $page = [];

    public function __construct() {
        add_action('admin_menu', [$this, 'admin_menu'], 20);
        add_filter('plugin_action_links_' . plugin_basename(Plugin::instance()->get_file()), [$this, 'plugin_action_links'], 10, 1);
    }

    // Add Schema Page to Theme Options
    public function admin_menu():void {
        if (!function_exists('acf_add_options_sub_page')) return;
        $this->page = acf_add_options_sub_page([
            'page_title' => Plugin::__('Schema Metadata'),
            'menu_title' => Plugin::__('Schema'),
            'parent_slug' => self::PARENT_SLUG,
            'menu_slug' => Plugin::instance()->get_id(),
            'update_button' => Plugin::__('Save'),
            'updated_message' => Plugin::__('Schema Updated'),
        ]);
    }

    // Add plugin link
    public function plugin_action_links(array $links):array {
        array_unshift($links, sprintf(
            '<a href="%s">%s</a>',
            esc_url($this->get_url()),
            Plugin::esc_html__('Settings')
        ));
        return $links;
    }

    private function get_menu_slug():string {
        if (empty($this->page) || !isset($this->page['menu_slug'])) return '';
        return (string)$this->page['menu_slug'];
    }

    public function get_url():string {
        return add_query_arg(array_filter([
            'page' => $this->get_menu_slug(),
        ]), admin_url(self::PARENT_SLUG));
    }

    // Settings Accessors

    public static function get_post_types():array {
        if (get_field('schema_setting_post_enable', 'option') !== true) return [];
        return is_array($post_types = get_field('schema_setting_post_type', 'option')) ? $post_types : [];
    }

    public static function has_post_types():bool {
        return !empty(self::get_post_types());
    }

}

Settings::instance();
