<?php
/**
 * @package CleverOgre
 * @subpackage OgreSchema
 * @version 0.1.0
 * @since 0.1.0
 */

namespace OgreSchema\Integration;

if (!defined('ABSPATH')) exit;

use OgreSchema\Singleton;
use OgreSchema\Data;

class YoastSEO {
    use Singleton;

    public function __construct() {
        add_filter('wpseo_json_ld_output', [$this, 'disable_wpseo'], 10, 2);
        add_filter('ogreschema/get_schema_object', [$this, 'append_schema_data'], 10, 2);
    }

    // Disable Yoast JSON Output
    public function disable_wpseo($data, $context) {
        return !Data::has_schema() ? $data : false;
    }

    // Append unset data from Yoast
    public function append_schema_data(array $schema_object, string|int $id):array {
        $wpseo_schema = $this->get_wpseo_schema();
        if (empty($wpseo_schema)) return $schema_object;
        foreach ($wpseo_schema as $key => $value) {
            if (isset($schema_object[$key]) && !empty($schema_object[$key])) continue;
            $schema_object[$key] = $value;
        }
        return $schema_object;
    }

    // Override filter and get Yoast JSON data
    private function get_wpseo_schema():array {
        remove_filter('wpseo_json_ld_output', [$this, 'disable_wpseo'], 10, 2);
        ob_start();
        do_action('wpseo_json_ld');
        $html = ob_get_clean();
        add_filter('wpseo_json_ld_output', [$this, 'disable_wpseo'], 10, 2);

        if (empty($html) || !preg_match_all('/<script[^>]*>(.+)<\/script>/m', $html, $matches)) return [];

        $data = [];
        foreach ($matches[1] as $json_str) {
            $json_data = json_decode($json_str, true);
            if (!is_null($json_data) && is_array($json_data)) $data = array_merge($data, $json_data);
        }
        return $data;
    }

}

YoastSEO::instance();
