<?php
/**
 * @package CleverOgre
 * @subpackage OgreModal
 * @version 0.4.2
 * @since 0.1.0
 */

namespace OgreModal;

if (!defined('ABSPATH')) exit;

class Fields {

    public static function load() {
        add_action('admin_menu', [__CLASS__, 'init_page']);
        Api::maybe_add_action('acf/init', [__CLASS__, 'load_field_groups']);
    }

    private static $acf_options_page;
    static function init_page() {
        if (!function_exists('acf_add_options_sub_page')) return;

        self::$acf_options_page = acf_add_options_sub_page(array(
            'page_title' => __('OgreModal Settings', Settings::get_option('textdomain')),
            'menu_title' => __('Settings', Settings::get_option('textdomain')),
            'parent_slug' => 'edit.php?post_type=modal',
        ));

        do_action('ogremodal/register_settings_page', self::$acf_options_page);
    }

    static function load_field_groups() {
        if (!function_exists('acf_add_local_field_group')) return;
        self::load_field_group('options', 'OgreModal Global Settings');
        self::load_field_group('post', 'Modal Configuration');
    }
    private static function load_field_group($key, $title = '') {
        if (!empty($title) && Api::field_group_exists($title)) return false;

        $path_format = '%s/assets/json/modal-%s.json';
        $path = sprintf($path_format, rtrim(get_stylesheet_directory(), '/'), $key);
        if (!file_exists($path)) $path = sprintf($path_format, rtrim(get_template_directory(), '/'), $key);
        if (!file_exists($path)) $path = sprintf($path_format, rtrim(Settings::get_option('path'), '/'), $key);
        if (!file_exists($path)) return;

        // Decode field group from json file (only 1 field group)
        $field_group = json_decode(file_get_contents($path), true);
        if (is_null($field_group) || !is_array($field_group) || empty($field_group)) return;
        $field_group = array_values($field_group)[0];

        acf_add_local_field_group($field_group);

        return true;
    }

}

Fields::load();
