<?php
/**
 * @package CleverOgre
 * @subpackage OgreModal
 * @version 0.4.2
 * @since 0.1.0
 */

if (!defined('ABSPATH')) exit;

use OgreModal\Api;

// Initialize Attribute Arrays
$data = Api::get_settings($post_id);
$classes = ['ogremodal-modal'];
$style = ['display' => 'none'];
$container_style = [];

// Additional CSS Classes
if (isset($data['class']) && !empty($data['class'])) $classes = array_unique(array_filter(array_merge($classes, explode(' ', $data['class']))));

// Click Out
if (isset($data['click_out']) && $data['click_out'] === true) $classes[] = 'has-click-out';

// Background Color
$background_color = Api::parse_hex_color($data['background']);
if (!$background_color || empty($background_color) || !is_array($background_color)) $background_color = array('r' => 0, 'g' => 0, 'b' => 0);

$background_opacity = $data['background_opacity'];
if (!is_numeric($background_opacity)) {
    $background_opacity = 0.5;
} else {
    $background_opacity = floatval($background_opacity) / 100;
}

$style['background-color'] = "rgba({$background_color['r']},{$background_color['g']},{$background_color['b']},$background_opacity)";

// Foreground Color
$foreground_color = Api::parse_hex_color($data['foreground']);
if (!$foreground_color || empty($foreground_color) || !is_array($foreground_color)) $foreground_color = array('r' => 255, 'g' => 255, 'b' => 255);
$style['color'] = "rgb({$foreground_color['r']},{$foreground_color['g']},{$foreground_color['b']})";

// Container Width
$width = $data['width'];
$width = is_numeric($width) ? floatval($width) : 980;
$container_style['width'] = "{$width}px";

// Dismiss Duration
$data['dismiss_type'] = $data['dismiss_duration'];
$data['dismiss_duration'] = Api::parse_dismiss_duration($data['dismiss_duration']);

// Transition Style
if (isset($data['transition_style']) && !isset($data['transition_type'])) $data['transition_type'] = $data['transition_style'];

// Filter Attribute Arrays
$data = apply_filters('ogremodal/modal_template_data', $data, $post_id);
$classes = apply_filters('ogremodal/modal_template_classes', $classes, $data, $post_id);
$style = apply_filters('ogremodal/modal_template_style', $style, $data, $post_id);
$container_style = apply_filters('ogremodal/modal_template_container_style', $container_style, $data, $post_id);

// Format data attributes
$data_attrs = array_filter($data, function ($key) {
    return !in_array($key, array('css'));
}, ARRAY_FILTER_USE_KEY);
$data_attrs = array_map(function ($prop, $value) {
    if (is_array($value) || is_object($value)) $value = json_encode($value);
    return "data-{$prop}=\"" . esc_attr($value) . '"';
}, array_keys($data_attrs), array_values($data_attrs));

// Format classes
$classes = array_map('sanitize_html_class', $classes);

// Format styling
array_walk($style, function (&$value, $prop) {
    $value = "{$prop}: {$value};";
});
array_walk($container_style, function (&$value, $prop) {
    $value = "{$prop}: {$value};";
});

$_post = get_post($post_id);
global $post;
$post = $_post;
setup_postdata($post);

?>
<article id="ogremodal_<?php esc_attr_e(sanitize_title($data['id'])); ?>" class="<?php esc_attr_e(implode(' ', $classes)); ?>" style="<?php esc_attr_e(implode(' ', $style)); ?>" <?php echo implode(' ', $data_attrs); ?>>
    <?php do_action('ogremodal/before_modal', $data, $post_id); ?>

    <?php if ($data['toolbar_enabled'] !== false) { ?>
    <?php do_action('ogremodal/before_toolbar', $data, $post_id); ?>
    <ul class="ogremodal-toolbar">
        <?php do_action('ogremodal/before_toolbar_inner', $data, $post_id); ?>
        <li class="ogremodal-toolbar__item ogremodal-toolbar__item-dismiss">
            <a href="#" class="ogremodal-dismiss" title="Close">Close</a>
        </li>
        <?php do_action('ogremodal/after_toolbar_inner', $data, $post_id); ?>
    </ul>
    <?php do_action('ogremodal/after_toolbar', $data, $post_id); ?>
    <?php } ?>

    <div class="ogremodal-container" style="<?php esc_attr_e(implode(' ', $container_style)); ?>">
        <?php do_action('ogremodal/before_container', $data, $post_id); ?>

        <?php if (!empty(trim(get_the_title()))) { ?>
        <header class="ogremodal-header<?php if ($data['title_visibility'] === false) echo ' title-hidden'; ?>">
            <?php do_action('ogremodal/before_header', $data, $post_id); ?>
            <h2 class="ogremodal-title<?php if ($data['title_visibility'] === false) echo ' screen-reader-text'; ?>"><?php
                apply_filters('ogremodal/header', esc_html_e(get_the_title()), $data, $post_id);
            ?></h2>
            <?php do_action('ogremodal/after_header', $data, $post_id); ?>
        </header>
        <?php } ?>

        <?php if (!empty($post->post_content)) { ?>
        <?php do_action('ogremodal/before_content', $data, $post_id); ?>
        <div class="ogremodal-content content"><?php
            if (wp_is_block_theme()) {
                echo OgreModal\Api::do_blocks($post_id, $post->post_content);
            } else {
                the_content();
            }
        ?></div>
        <?php do_action('ogremodal/after_content', $data, $post_id); ?>
        <?php } ?>

        <?php do_action('ogremodal/after_container', $data, $post_id); ?>
    </div>

    <?php do_action('ogremodal/after_modal', $data, $post_id); ?>
</article>
<?php if (!empty($data['css'])) { ?>
<style type="text/css"><?php echo apply_filters('ogremodal/custom_css', $data['css']); ?></style>
<?php } ?>
