<?php
/**
 * @package CleverOgre
 * @subpackage FareHarbor
 * @version 0.1.0
 * @since 0.1.0
 */

if (!defined('ABSPATH')) exit;

if (!function_exists('the_fareharbor_content')) {
    function the_fareharbor_content($post_id = false) {
        if ($post_id === false) $post_id = get_the_ID();
        if (is_string($post_id) && is_numeric($post_id)) $post_id = intval($post_id);
        if (!is_int($post_id) || get_post_type($post_id) != \Ogre\FareHarbor\Item::get_post_type()) return false;
        do_action('ogre/fareharbor_content', $post_id);
        return true;
    }
}

if (!function_exists('get_fareharbor_content')) {
    function get_fareharbor_content($post_id = false) {
        ob_start();
        $result = the_fareharbor_content($post_id);
        $content = ob_get_contents();
        ob_end_clean();
        if ($result !== true) return $result;
        return $content;
    }
}

if (!function_exists('get_fareharbor_gallery')) {
    function get_fareharbor_gallery($post_id = false, $plugin_only = false) {
        return \Ogre\FareHarbor\Template::include_template_part(['post_id' => $post_id], 'gallery', null, [], $plugin_only);
    }
}
if (!function_exists('the_fareharbor_gallery')) {
    function the_fareharbor_gallery($post_id = false, $plugin_only = false) {
        echo get_fareharbor_gallery($post_id, $plugin_only);
    }
}

if (!function_exists('get_fareharbor_bullets')) {
    function get_fareharbor_bullets($post_id = false, $plugin_only = false) {
        return \Ogre\FareHarbor\Template::include_template_part(['post_id' => $post_id], 'bullets', null, [], $plugin_only);
    }
}
if (!function_exists('the_fareharbor_bullets')) {
    function the_fareharbor_bullets($post_id = false, $plugin_only = false) {
        echo get_fareharbor_bullets($post_id, $plugin_only);
    }
}
