<?php
/**
 * @package CleverOgre
 * @subpackage OgreModal
 * @version 0.4.2
 * @since 0.1.0
 */

namespace OgreModal;

if (!defined('ABSPATH')) exit;

class Expiration {

    public static function load() {
        add_filter('ogrealert/validate_modal', [__CLASS__, 'check'], 10, 2);
    }

    static function check($valid, $post_id) {
        $exp_time = self::get_timestamp($post_id);
        if (!$exp_time) return $valid;

        $remaining = $exp_time - time();
        if ($remaining <= 0) {
            wp_trash_post($post_id);
            $valid = false;
        }

        return $valid;
    }

    public static function get_timestamp($post_id) {
        $value = get_field('expiration', $post_id);
        if (empty($value)) return false;

        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $value)) return false;

        $time = strtotime($value);
        return !!$time ? $time : false;
    }

}

Expiration::load();
