<?php
/**
 * @package CleverOgre
 * @subpackage BisTrack
 * @version 0.1.1
 * @since 0.1.1
 */

namespace LearnDash\Certificate\PhpWord;

defined('ABSPATH') || exit;

use \OgreCore\Field;
use \OgreCore\Field\CheckBox as CheckBoxField;

abstract class Converter {

    abstract public static function valid():bool;
    abstract public static function get_extension():string;

    function __construct() { }

    public function convert(string $input, string $output = '', bool $delete = false) {
        if (!file_exists($input)) return false;

        if (empty($output)) $output = $this->get_tmp_path($input);
        if (file_exists($output)) unlink($output);

        if (!$this->_convert($input, $output)) return false;
        if (!file_exists($output)) return false;

        if (!!$delete) unlink($input);

        return $output;
    }
    abstract protected function _convert(string $input, string $output):bool;

    private function get_tmp_path(string $filepath):string {
        return sprintf('%s/%s.%s', sys_get_temp_dir(), pathinfo($filepath)['filename'], static::get_extension());
    }

}
