<?php
/**
 * @package CleverOgre
 * @subpackage WP Job Manager - JobAdder Integration
 * @since WP Job Manager - JobAdder Integration 0.1.1
 */

namespace JobAdder\API;

if (!defined('ABSPATH')) exit;

define('JOBADDER_HOST', 'api.jobadder.com');

define('JOBADDER_ID_API', 'https://id.jobadder.com/connect/');
define('JOBADDER_ID_AUTHORIZE_ENDPOINT', 'authorize');
define('JOBADDER_ID_TOKEN_ENDPOINT', 'token');

define('JOBADDER_JOBS_ENDPOINT', 'jobs');
define('JOBADDER_JOBADS_ENDPOINT', 'jobads');
define('JOBADDER_COMPANIES_ENDPOINT', 'companies');
define('JOBADDER_COMPANIES_LOGO_ENDPOINT', 'logo');
define('JOBADDER_CONTACTS_ENDPOINT', 'contacts');
define('JOBADDER_WEBHOOK_ENDPOINT', 'webhooks');

class Utility {

    public static function getJson($url, $token = true) {
        if (!!$token && !\JobAdder\API\Auth::get_access_token()) return false;

        $headers = array(
            sprintf('Host: %s', JOBADDER_HOST),
            'Accept: image/jpeg',
        );
        if (!!$token) $headers[] = sprintf('Authorization: Bearer %s', \JobAdder\API\Auth::get_access_token());

        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        $json_str = curl_exec($conn);
        curl_close($conn);
        if (empty($json_str)) return false;

        // Parse json response
        return json_decode($json_str, true);
    }

    public static function postForm($url, $data, $token = true) {
        if (!!$token && !\JobAdder\API\Auth::get_access_token()) return false;

        $headers = array(
            'Content-Type: application/x-www-form-urlencoded',
        );
        if (!!$token) $headers[] = sprintf('Authorization: Bearer %s', \JobAdder\API\Auth::get_access_token());

        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_POST, 1);
        curl_setopt($conn, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($conn, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        $json_str = curl_exec($conn);
        curl_close($conn);
        if (empty($json_str)) return false;

        // Parse json response
        return json_decode($json_str, true);
    }

    public static function postJson($url, $data, $token = true) {
        if (!!$token && !\JobAdder\API\Auth::get_access_token()) return false;

        $headers = array(
            'Content-Type: application/json',
        );
        if (!!$token) $headers[] = sprintf('Authorization: Bearer %s', \JobAdder\API\Auth::get_access_token());

        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_POST, 1);
        curl_setopt($conn, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($conn, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        $json_str = curl_exec($conn);
        curl_close($conn);
        if (empty($json_str)) return false;

        // Parse json response
        return json_decode($json_str, true);
    }

    public static function getImage($url, $token = true) {
        if (!!$token && !\JobAdder\API\Auth::get_access_token()) return false;

        $headers = array(
            'Host: api.jobadder.com',
            'Accept: image/jpeg',
        );
        if (!!$token) $headers[] = sprintf('Authorization: Bearer %s', \JobAdder\API\Auth::get_access_token());

        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        $image_data = curl_exec($conn);
        curl_close($conn);

        return !$image_data ? false : $image_data;
    }

    public static function delete($url, $token = true) {
        if (!!$token && !\JobAdder\API\Auth::get_access_token()) return false;

        $headers = array();
        if (!!$token) $headers[] = sprintf('Authorization: Bearer %s', \JobAdder\API\Auth::get_access_token());

        // Perform DELETE request
        $conn = curl_init();
        curl_setopt($conn, CURLOPT_URL, $url);
        curl_setopt($conn, CURLOPT_CUSTOMREQUEST, 'DELETE');
        curl_setopt($conn, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
        curl_exec($conn);
        curl_close($conn);

        return true;
    }

    private static function buildUrl($api, $endpoint = '', $format = '{api}{endpoint}', $vars = array(), $args = array()) {
        // Build replacement tags
        $tags = array('{api}', '{endpoint}');
        $values = array($api, $endpoint);
        if (!empty($vars)) {
            foreach ($vars as $tag => $value) {
                $tags[] = '{' . $tag . '}';
                $values[] = urlencode($value);
            }
        }

        // Construct base url
        $url = str_replace($tags, $values, $format);
        if (!wp_http_validate_url($url)) return false;

        // Add query args
        if (!empty($args)) $url = add_query_arg($args, $url);

        return $url;
    }

    public static function buildApiUrl($endpoint = '', $format = '{api}{endpoint}', $vars = array(), $args = array()) {
        return self::buildUrl(\JobAdder\Settings::get('api_url'), $endpoint, $format, $vars, $args);
    }

    public static function buildApiIdUrl($endpoint, $id, $args = array()) {
        return self::buildApiUrl($endpoint, '{api}{endpoint}/{id}', array('id' => $id), $args);
    }

    public static function buildIdUrl($endpoint = '', $format = '{api}{endpoint}', $vars = array(), $args = array()) {
        return self::buildUrl(JOBADDER_ID_API, $endpoint, $format, $vars, $args);
    }

}
