<?php
/**
 * @package CleverOgre
 * @subpackage learndash-certificates-phpword
 * @version 0.1.1
 * @since 0.1.1
 */

namespace LearnDash\Certificate\PhpWord;

defined('ABSPATH') || exit;

use PhpOffice\PhpWord\IOFactory;
use PhpOffice\PhpWord\Settings;

class DOMPDFConverter extends Converter {

    public static function valid():bool {
        return class_exists('\PhpOffice\PhpWord\IOFactory') && class_exists('\PhpOffice\PhpWord\Settings');
    }

    public static function get_extension():string {
        return 'pdf';
    }

    private $unoconv = null;
    function __construct() {
        parent::__construct();
    }

    protected function _convert(string $input, string $output):bool {
        try {
            Settings::setPdfRendererName(Settings::PDF_RENDERER_DOMPDF);
            Settings::setPdfRendererPath('.'); // Any writable directory here. It will be ignored.

            $phpWord = IOFactory::load($input);
            $phpWord->save($output, strtoupper(static::get_extension()));
        } catch (Exception $e) {
            return false;
        }

        return true;
    }

}
