<?php
/**
 * @package CleverOgre
 * @subpackage OgreModal
 * @version 0.4.2
 * @since 0.1.0
 */

namespace OgreModal;

if (!defined('ABSPATH')) exit;

class Modal {

    public static function load() {
        add_action('init', [__CLASS__, 'register'], 20);
        if (!is_admin()) add_action('wp', [__CLASS__, 'init']);
        add_action('acf/prepare_field/key=field_6030394266b47', [__CLASS__, 'prepare_id'], 10, 1);
    }

    static function register() {
        register_post_type('modal', [
            'labels' => Api::get_labels(__('Modals', 'pipeline'), __('Modal', 'pipeline')),
            'supports' => ['title', 'editor', 'author', 'revisions'],
            'exclude_from_search' => true,
            'public' => false,
            'publicly_queryable' => false,
            'show_in_nav_menus' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'has_archive' => false,
            'show_in_admin_bar' => true,
            'hierarchical' => false,
            'menu_position' => 20,
            'taxonomies' => [],
            'menu_icon' => 'dashicons-megaphone',
            'show_in_rest' => true, // Enable Gutenberg
        ]);
    }

    static function init() {
        if (is_admin() || !Api::has_valid_modals()) return;

        add_action('wp_enqueue_scripts', [__CLASS__, 'enqueue_scripts']);
        add_action('wp_footer', [__CLASS__, 'footer']);

        // OgreModal Content Filters
        add_filter('ogremodal/content', 'wptexturize');
        add_filter('ogremodal/content', 'convert_smilies');
        add_filter('ogremodal/content', 'convert_chars');
        add_filter('ogremodal/content', 'wpautop');
        add_filter('ogremodal/content', 'shortcode_unautop');
        add_filter('ogremodal/content', 'do_shortcode');
    }

    static function enqueue_scripts() {
        wp_enqueue_style(Settings::get_option('textdomain'), Settings::get_option('dir') . 'assets/sass/style.css', [], Settings::get_option('version'), 'all');
        wp_enqueue_script(Settings::get_option('textdomain'), Settings::get_option('dir') . 'assets/js/script.js', ['jquery'], Settings::get_option('version'), true);
        wp_localize_script(Settings::get_option('textdomain'), Settings::get_option('textdomain'), Api::get_settings());
    }

    static function footer() {
        Api::load_modals(true);
    }

    static function prepare_id($field) {
        if (!empty($field['value']) || !isset($_GET['post']) || !is_numeric($_GET['post'])) return $field;
        $field['value'] = Api::get_id(absint($_GET['post']));
        return $field;
    }

}

Modal::load();
