<?php
/**
 * @package CleverOgre
 * @subpackage OgreModal
 * @version 0.4.2
 * @since 0.1.0
 */

namespace OgreModal;

if (!defined('ABSPATH')) exit;

class Shortcode {

    public static function load() {
        if (is_admin() || !Api::has_valid_modals()) return;

        add_action('wp_enqueue_scripts', array(__CLASS__, 'enqueue_scripts'));
        add_action('wp_footer', array(__CLASS__, 'footer'));

        // OgreModal Content Filters
        add_filter('ogremodal/content', array(__CLASS__, 'do_shortcode'), 10);
    }

    private static function get_shortcode_tags() {
        $tags = apply_filters('ogremodal/shortcode_tags', array());
        if (empty($tags) || !is_array($tags)) return false;
        return $tags;
    }

    static function do_shortcode($content, $ignore_html = false) {
        if (strpos($content, '[') === false) return $content;
        if (($shortcode_tags = $this->get_shortcode_tags()) === false) return $content;

        // Find all registered tag names in $content
        preg_match_all('@\[([^<>&/\[\]\x00-\x20=]++)@', $content, $matches);
        $tagnames = array_intersect(array_keys($shortcode_tags), $matches[1]);
        if (empty($tagnames)) return $content;

        $content = do_shortcodes_in_html_tags($content, $ignore_html, $tagnames);

        $pattern = get_shortcode_regex($tagnames);
        $content = preg_replace_callback("/$pattern/", 'do_shortcode_tag', $content);

        // Always restore square braces so we don't break things like <!--[if IE ]>
        $content = unescape_invalid_shortcodes($content);

        return $content;
    }

    static function do_shortcode_tag($m) {
        if (($shortcode_tags = self::get_shortcode_tags()) === false) return $m[0];

        // Allow [[foo]] syntax for escaping a tag
        if ($m[1] == '[' && $m[6] == ']') return substr($m[0], 1, -1);

        $tag = $m[2];
        $attr = shortcode_parse_atts($m[3]);

        if (!is_callable($shortcode_tags[$tag])) {
            /* translators: %s: shortcode tag */
            $message = sprintf(__('Attempting to parse a shortcode without a valid callback: %s'), $tag);
            _doing_it_wrong(__FUNCTION__, $message, '4.3.0');
            return $m[0];
        }

        // TODO: Needs more here!
    }

}

Shortcode::load();
