<?php
/*
Plugin Name: OgreModal
Plugin URI: http://cleverfile.net/plugins/ogremodal/
Description: OgreModal is a plugin developed by CleverOgre in Pensacola, Florida.
Version: 0.4.2
Since: 0.1.0
Author: CleverOgre
Author URI: http://cleverogre.com/
Text Domain: ogremodal
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright: CleverOgre, Inc.
*/

namespace OgreModal;

if (!defined('ABSPATH')) exit;

class Plugin {

    public static function init() {
        $path = self::get_path(__FILE__);

        // Initialize Settings
        include_once($path . 'settings.php');
        Settings::init();

        // Default Settings
        if (!function_exists('get_plugin_data')) require_once(ABSPATH . 'wp-admin/includes/plugin.php');
        $plugin = \get_plugin_data(__FILE__);
        Settings::set_option('name', $plugin['Name']);
        Settings::set_option('textdomain', $plugin['TextDomain']);
        Settings::set_option('version', $plugin['Version']);
        Settings::set_option('capability', 'edit_posts');
        Settings::set_option('path', $path);
        Settings::set_option('dir', self::get_dir(__FILE__));
        Settings::set_option('hook', self::get_hook(__FILE__));

        // Setup Plugin Updates
        include_once(Settings::get_option('path') . 'lib/wp-package-updater/class-wp-package-updater.php'); // Include private plugin updating library
        $package_updater = new \WP_Package_Updater(
            'https://plugins.cleverogre.com',
            wp_normalize_path(__FILE__),
            wp_normalize_path(plugin_dir_path(__FILE__)),
            false // License key required
        );

        // Set Text Domain
        load_plugin_textdomain(Settings::get_option('textdomain'), false, plugin_basename(dirname(__FILE__)) . '/lang');

        // Filters
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), [__CLASS__, 'action_links']);

        // Requirements Check
        add_action('plugins_loaded', [__CLASS__, 'requirements_check'], 1, 0);

        // Delay loading
        add_action('plugins_loaded', [__CLASS__, 'load'], 20, 0);
    }

    private static $requirements;
    static function requirements_check() {
        // Check for plugin requirements
        self::$requirements = [
            'acf' => [
                'name' => __('Advanced Custom Fields Pro', Settings::get_option('textdomain')),
                'url' => 'https://www.advancedcustomfields.com/',
                'valid' => (function_exists('is_plugin_active') && is_plugin_active('advanced-custom-fields-pro/acf.php')) || class_exists('\ACF'),
            ],
        ];

        $invalid = false;
        foreach (self::$requirements as $key => $data) {
            if (!!$data['valid']) continue;

            add_action('admin_notices', function () use ($data) {
                $message = sprintf(
                    __('In order to use the %1$s plugin, it is required that you install and activate the %3$s plugin. You can do this on the <a href="%2$s">plugins</a> page when logged in as an administrator. To download this plugin, visit the <a href="%4$s" target="_blank">%3$s website</a>.', 'ogrewoo'),
                    get_plugin_data(__FILE__)['Name'],
                    esc_url(admin_url('plugins.php')),
                    esc_html($data['name']),
                    esc_url($data['url'])
                );
                printf('<div class="%s"><p>%s</p></div>', esc_attr('notice notice-error'), wpautop(wp_kses_post($message)));
            });

            $invalid = true;
        }

        if (!!$invalid) remove_action('plugins_loaded', [__CLASS__, 'load'], 20, 0);
    }

    static function load() {
        // Core Classes
        include_once(Settings::get_option('path') . 'inc/api.php'); // Global Functions
        include_once(Settings::get_option('path') . 'inc/fields.php'); // Field Groups and Settings Page
        include_once(Settings::get_option('path') . 'inc/modal.php'); // Modal Functionality
        //include_once(Settings::get_option('path') . 'inc/expiration.php'); // Modal publish expiration handling
        //include_once(Settings::get_option('path') . 'inc/shortcode.php'); // Modal Shortcodes (in modal content and controls on pages)
    }

    // Plugin Action Links

    static function action_links($links) {
        array_unshift($links, '<a href="' . esc_url(admin_url('edit.php?post_type=modal&page=acf-options-settings')) . '">' . __('Settings', Settings::get_option('textdomain')) . '</a>');
        return $links;
    }

    // Plugin File Path Calculations

    private static function get_path($file) {
        return trailingslashit(dirname($file));
    }
    private static function get_dir($file) {
        $dir = trailingslashit(dirname($file));
        $count = 0;

        // Sanitize for Win32 installs
        $dir = str_replace('\\', '/', $dir);

        // If file is in plugins folder
        $wp_plugin_dir = str_replace('\\', '/', WP_PLUGIN_DIR);
        $dir = str_replace($wp_plugin_dir, plugins_url(), $dir, $count);

        if ($count < 1) {
            // If file is in wp-content folder
            $wp_content_dir = str_replace('\\', '/', WP_CONTENT_DIR);
            $dir = str_replace($wp_content_dir, content_url(), $dir, $count);
        }

        if ($count < 1) {
            // If file is in ??? folder
            $wp_dir = str_replace('\\', '/', ABSPATH);
            $dir = str_replace($wp_dir, site_url('/'), $dir);
        }

        return $dir;
    }
    private static function get_hook($file) {
        return basename(dirname($file)) . '/' . basename($file);
    }

}

Plugin::init();
