/*
File Name: cookie.ts
  ____ _                      ___
 / ___| | _____   _____ _ __ / _ \  __ _ _ __ ___
| |   | |/ _ \ \ / / _ \ '__| | | |/ _` | '__/ _ \
| |___| |  __/\ V /  __/ |  | |_| | (_| | | |  __/
 \____|_|\___| \_/ \___|_|   \___/ \__, |_|  \___|
                                   |___/
*/

class Cookie {
    private name:string;

    constructor(name:string) {
        this.name = name;
    }

    public read() {
        var result = new RegExp('(?:^|; )' + encodeURIComponent(this.name) + '=([^;]*)').exec(document.cookie);
        return result ? result[1] : null;
    }

    public write(value:string, days?:number) {
        if (!days) { days = 365; }

        var date:Date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));

        var expires:string = "; expires=" + date.toUTCString();
        var str:string = this.name + '=' + value + expires + "; path=/";
        document.cookie = this.name + '=' + value + expires + "; path=/";
    }

    public remove() {
        this.write("", -1);
    }
}

class CookieList {
    private cookie:Cookie;
    private items:Array<number>;

    constructor(name:string) {
        this.cookie = new Cookie(name);
        var value:string = this.cookie.read();
        this.items = value ? value.split(/,/) : new Array();
    }

    public add(value:number) {
        if (this.items.indexOf(value) >= 0) { return; }
        this.items.push(value);
        this.update();
    }

    public remove(value:number) {
        var index:number = this.items.indexOf(value);
        if (index != -1) {
            this.items.splice(index, 1);
        }
        this.update();
    }

    public clear() {
        this.items.length = 0;
        this.update();
    }

    public getItems() {
        return this.items;
    }

    private update() {
        if (this.items == null || this.items.length <= 0) {
            this.cookie.remove();
        } else {
            this.cookie.write(this.items.join(','));
        }
    }
}
