<?php
/**
 * @package CleverOgre
 * @subpackage QLess
 * @since QLess 0.2.0
 */

if (!defined('ABSPATH')) exit;

if (!class_exists('QLessWidget')) {
    class QLessWidget {
        public function __construct() {
            add_action('widgets_init', array($this, 'widgets_init'));
        }

        function widgets_init() {
            register_widget('QLessWaitTimes');
        }
    }

    new QLessWidget();
}

if (!class_exists('QLessWaitTimes')) {
    class QLessWaitTimes extends WP_Widget {
        private $api;

        public function __construct() {
            $widget_options = array(
                'classname' => 'qless-wait-times',
                'description' => 'Widget to display queue wait times via QLess API.',
            );
            parent::__construct('QLessWaitTimes', 'QLess Wait Times', $widget_options);

            $this->api = QLessApi();
        }

        public function widget($args, $instance) {

            $locations = $this->api->kiosk_locations($instance['ids']);
            if ($locations == false || empty($locations)) return;

            echo $args['before_widget'];

            $title = apply_filters('widget_title', $instance['title']);
            if (!empty($title)) {
                echo $args['before_title'] . $title . $args['after_title'];
            }

            $description = $instance['description'];
            if (!empty($description)) {
                echo '<p class="widget-description">' . esc_html($description) . '</p>';
            }

            echo '<table class="qless-table">';

            $line_link = $instance['line_link'] ? 'true' : 'false';
            $appt_link = $instance['appt_link'] ? 'true' : 'false';

            echo '<thead><tr>';
            echo '<th class="location-name">' . __('Location', 'qless') . '</th>';
            echo '<th class="wait-time">' . __('Wait', 'qless') . '</th>';
            if ($line_link == 'true') {
                echo '<th class="line-link">' . __('Get in Line', 'qless') . '</th>';
            }
            if ($appt_link == 'true') {
                echo '<th class="appt-link">' . __('Make Appt.', 'qless') . '</th>';
            }
            echo '</tr></thead>';

            echo '<tbody>';
            foreach ($locations as $location) {
                if (!isset($location['id']) || empty($location['id'])) continue;

                $queues = $this->api->kiosk_queues($location['id']);
                if ($queues == false || empty($queues)) continue;

                foreach ($queues as $queue) {
                    $wait = $this->api->kiosk_waitInfo($queue['id']);
                    if ($wait == false || empty($wait)) continue;
                    $wait = $wait[0];

                    echo '<tr id="qless-location-' . $location['id'] . '-queue-' . $queue['id'] . '">';

                    $loc_page = get_page_by_title($location['title'], OBJECT, 'location');

                    echo '<td class="location-name">';
                    if ($loc_page != null && $loc_page != false) {
                        echo '<a href="' . get_the_permalink($loc_page) . '" title="' . get_the_title($loc_page) . '">';
                    }
                    echo $location['title'];
                    if ($loc_page != null && $loc_page != false) {
                        echo '</a>';
                    }
                    echo '</td>';

                    echo '<td class="wait-time">' . $wait['description'] . '</td>';

                    if ($line_link == 'true') {
                        echo '<td class="line-link"><a href="https://kiosk.qless.com/kiosk/app/home/' . $location['id'] . '" target="_blank">' . __('Get in Line', 'qless') . '</a></td>';
                    }

                    if ($appt_link == 'true') {
                        echo '<td class="appt-link"><a href="https://kiosk.qless.com/kiosk/app/home/' . $location['id'] . '" target="_blank">' . __('Make Appointment', 'qless') . '</a></td>';
                    }

                    echo '</tr>';

                    break;
                }
            }
            echo '</tbody>';

            echo '</table>';

            echo $args['after_widget'];
        }

        public function form($instance) {
            $title = !empty($instance['title']) ? $instance['title'] : '';
            $description = !empty($instance['description']) ? $instance['description'] : '';
            $ids = !empty($instance['ids']) ? $instance['ids'] : '';
            $line_link = $instance['line_link'] ? 'on' : 'off';
            $appt_link = $instance['appt_link'] ? 'on' : 'off';
?>
<p>
    <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'qless'); ?></label>
    <input class="widefat title" type="text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>" />
</p>
<p>
    <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'qless'); ?></label>
    <textarea class="widefat description" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
</p>
<p>
    <label for="<?php echo $this->get_field_id('ids'); ?>"><?php _e('Location Ids: <small>(comma-separated)</small>', 'qless'); ?></label>
    <input class="widefat ids" type="text" id="<?php echo $this->get_field_id('ids'); ?>" name="<?php echo $this->get_field_name('ids'); ?>" value="<?php echo esc_attr($ids); ?>" />
</p>
<p>
    <input class="checkbox" type="checkbox" <?php checked($line_link, 'on'); ?> id="<?php echo $this->get_field_id('line_link'); ?>" name="<?php echo $this->get_field_name('line_link'); ?>" />
    <label for="<?php echo $this->get_field_id('line_link'); ?>"><?php _e('Show "Get In Line" Link?', 'qless'); ?></label>
</p>
<p>
    <input class="checkbox" type="checkbox" <?php checked($appt_link, 'on'); ?> id="<?php echo $this->get_field_id('appt_link'); ?>" name="<?php echo $this->get_field_name('appt_link'); ?>" />
    <label for="<?php echo $this->get_field_id('appt_link'); ?>"><?php _e('Show "Make Appointment" Link?', 'qless'); ?></label>
</p>
<?php
        }

        public function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = strip_tags($new_instance['title']);
            $instance['description'] = strip_tags($new_instance['description']);
            $instance['ids'] = strip_tags($new_instance['ids']);
            $instance['line_link'] = strip_tags($new_instance['line_link']);
            $instance['appt_link'] = strip_tags($new_instance['appt_link']);
            return $instance;
        }
    }
}
