<?php
/**
 * @package CleverOgre
 * @subpackage woocommerce-download-template
 * @version 0.1.0
 * @since 0.1.0
 */

namespace WooCommerce\DownloadTemplate;

defined('ABSPATH') || exit;

class Values {
    use Singleton;

    public function __construct() { }

    private function get_default_args():array {
        return apply_filters('wc_download_template_values_default_args', [
            'order_id' => false, // TODO: Not implemented
            'product_id' => false, // TODO: Not implemented
            'gf_entry' => false,
            'gf_form' => false,
        ]);
    }

    private function get_args(array $args = []):array {
        return apply_filters('wc_download_template_values_args', wp_parse_args($args, $this->get_default_args()));
    }

    public function get_default():array {
        return apply_filters('wc_download_template_default_values', [
            'year' => date('Y'),
            'month' => date('F'),
            'day' => date('j'),
            'date' => date(get_option('date_format')),
            'time' => date(get_option('time_format')),
        ]);
    }

    public function get(array $args = [], array $_values = []):array {
        $args = $this->get_args($args);

        $values = apply_filters('wc_download_template_values', $this->get_default(), $args);
        if (is_array($_values) && !empty($_values)) $values = array_merge($values, $_values);

        $this->sanitize($values);
        return $values;
    }

    private function sanitize(array &$values) {
        foreach ($values as $key => &$value) {
            if (is_array($value)) {
                if (!empty($value) && is_string(array_values($value)[0])) {
                    $value = implode(', ', $value);
                } else {
                    $value = '';
                }
            } else if (is_object($value)) {
                $value = '';
            }
        }
    }

    public function get_example(array $_values = []) {
        $values = apply_filters('wc_download_template_example_values', $this->get_default());
        if (is_array($_values) && !empty($_values)) $values = array_merge($values, $_values);

        $this->sanitize($values);
        return $values;
    }

}
