const defaultConfig = require('@wordpress/scripts/config/webpack.config');
const WooCommerceDependencyExtractionWebpackPlugin = require('@woocommerce/dependency-extraction-webpack-plugin');
const path = require('path');

const requestToExternal = (request) => {
	const wcDepMap = {
		'@woocommerce/blocks-checkout': [ 'window', 'wc', 'blocksCheckout' ],
		'@woocommerce/blocks-registry': ['window', 'wc', 'wcBlocksRegistry'],
		'@woocommerce/settings': [ 'window', 'wc', 'wcSettings' ],
	};

	if (wcDepMap[request]) {
		return wcDepMap[request];
	}
};

const requestToHandle = (request) => {
	const wcHandleMap = {
		'@woocommerce/blocks-checkout': 'wc-blocks-checkout',
		'@woocommerce/blocks-registry': 'wc-blocks-registry',
		'@woocommerce/settings': 'wc-settings'
	};

	if (wcHandleMap[request]) {
		return wcHandleMap[request];
	}
};

// Export configuration.
module.exports = {
	...defaultConfig,
	entry: {
		'frontend/blocks': '/src/js/frontend/index.js',
	},
	output: {
		path: path.resolve( __dirname, 'assets/js' ),
		filename: '[name].js',
	},
	plugins: [
		...defaultConfig.plugins.filter(
			(plugin) =>
				plugin.constructor.name !== 'DependencyExtractionWebpackPlugin'
		),
		new WooCommerceDependencyExtractionWebpackPlugin({
			injectPolyfill: true,
			requestToExternal,
			requestToHandle
		})
	]
};
