<?php
/**
 * @package CleverOgre
 * @subpackage WP Job Manager - JobAdder Integration
 * @since WP Job Manager - JobAdder Integration 0.1.1
 */

namespace JobAdder\API;

if (!defined('ABSPATH')) exit;

class Companies {

    public static function getCompanyByJob(int $jobId) {
        $url = \JobAdder\API\Utility::buildApiIdUrl(JOBADDER_JOBS_ENDPOINT, $jobId);
        if (!$url) return false;

        $data = \JobAdder\API\Utility::getJson($url);
        if (!isset($data['jobId']) || !isset($data['company'])) return false;

        return (array)$data['company'];
    }

    public static function getCompanyIdByJob(int $jobId, int $adId = null, $force = false) {
        if ($adId != null && !!($post_id = \JobAdder\API\JobAds::getPostId($adId)) && !$force) {
            $meta_value = get_post_meta($post_id, '_companyid', true);
            if (is_numeric($meta_value)) return (int)intval($meta_value);
        }

        $company = self::getCompanyByJob($jobId);
        if (!$company || !isset($company['companyId'])) return false;

        $companyId = (int)$company['companyId'];

        // Update post meta
        if ($adId != null && !!$post_id) {
            update_post_meta($post_id, '_companyid', strval($companyId));
        }

        return $companyId;
    }

    public static function getCompanyInfo(int $companyId) {
        $url = \JobAdder\API\Utility::buildApiIdUrl(JOBADDER_COMPANIES_ENDPOINT, $companyId);
        if (!$url) return false;

        $data = \JobAdder\API\Utility::getJson($url);
        if (!$data || !isset($data['companyId'])) return false;

        return (array)$data;
    }

    public static function getLogo(int $jobId, int $companyId = null, $force = false) {
        $post_id = \JobAdder\API\Jobs::getPostId($jobId);
        if (!$post_id) return false;

        $logo = get_the_post_thumbnail_url($post_id);
        if (!!$logo && !$force) return $logo;

        if (is_null($companyId)) $companyId = self::getCompanyIdByJob($jobId);
        if ($companyId === false || is_null($companyId) || !is_int($companyId)) return false;

        $url = \JobAdder\API\Utility::buildApiUrl(JOBADDER_COMPANIES_ENDPOINT, '{api}{endpoint}/{companyId}/{logoEndpoint}', array(
            'companyId' => $companyId,
            'logoEndpoint' => JOBADDER_COMPANIES_LOGO_ENDPOINT,
        ));
        if (!$url) return false;

        // Get image from API
        $image_data = \JobAdder\API\Utility::getImage($url);
        if (!$image_data) return false;

        // Save image to uploads folder
        $filename = "jobadder-{$companyId}-logo.jpg";
        $file_data = wp_upload_bits($filename, null, $image_data);
        if (!is_array($file_data) || !!$file_data['error']) return false;

        // Set image as post thumbnail
        $attachment = array(
            'post_mime_type' => $file_data['type'],
            'post_parent' => $post_id,
            'post_title' => sanitize_title($filename),
            'post_content' => '',
            'post_status' => 'inherit',
        );
        $attachment_id = wp_insert_attachment($attachment, $file_data['file'], $post_id);
        if (is_wp_error($attachment_id)) return false;

        require_once(ABSPATH . 'wp-admin/includes/image.php');

        $attachment_data = wp_generate_attachment_metadata($attachment_id, $file_data['file']);

        wp_update_attachment_metadata($attachment_id, $attachment_data);
        set_post_thumbnail($post_id, $attachment_id);

        return $file_data['url'];
    }

    public static function getContact(int $contactId) {
        $url = \JobAdder\API\Utility::buildApiIdUrl(JOBADDER_COMPANIES_ENDPOINT, $companyId);
        if (!$url) return false;

        $data = \JobAdder\API\Utility::getJson($url);
        if (!$data || !isset($data['companyId'])) return false;

        return (array)$data;
    }

}
