<?php
/*
Plugin Name: WP Job Manager - JobAdder Integration
Plugin URI: https://plugins.cleverogre.com/plugin/wpjm-jobadder/
Description: Ogre JobAdder is a plugin developed by CleverOgre in Pensacola, Florida. This plugin will help sync jobs from JobAdder with WP Job Manager.
Version: 0.1.3
Author: CleverOgre
Author URI: https://cleverogre.com/
Icon1x: https://plugins.cleverogre.com/plugin/wpjm-jobadder/?asset=icon-sm
Icon2x: https://plugins.cleverogre.com/plugin/wpjm-jobadder/?asset=icon
BannerHigh: https://plugins.cleverogre.com/plugin/wpjm-jobadder/?asset=banner
BannerLow: https://plugins.cleverogre.com/plugin/wpjm-jobadder/?asset=banner-sm
Text Domain: wpjm-jobadder
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright: © 2023 CleverOgre, Inc. All rights reserved.

  ||         ||          __        ||      ||
  ||  /|||\  || __      //\\    __ ||   __ ||  /|||\   /|||\
  || ||   || ||/  \\   ||  ||  // \||  // \|| ||   || ||   \
  || ||   || ||    ||  |||||| ||   || ||   || ||===/  ||
////  \|||/   \\||//   ||  ||  \|||/   \|||/   \===   ||

*/

namespace JobAdder;

if (!defined('ABSPATH')) exit;

class Plugin {

    public static function init() {
        $path = self::get_path(__FILE__);

        // Initialize Settings
        include_once($path . 'inc/settings.php');
        \JobAdder\Settings::init();

        // Default Settings
        \JobAdder\Settings::set('name', 'WP Job Manager - JobAdder Integration');
        \JobAdder\Settings::set('version', '0.1.3');
        \JobAdder\Settings::set('capability', 'manage_options');
        \JobAdder\Settings::set('path', $path);
        \JobAdder\Settings::set('dir', self::get_dir(__FILE__));
        \JobAdder\Settings::set('hook', self::get_hook(__FILE__));

        // Setup Plugin Updates
        include_once(\JobAdder\Settings::get('path') . 'lib/wp-package-updater/class-wp-package-updater.php'); // Include private plugin updating library
        $package_updater = new \WP_Package_Updater(
            'https://plugins.cleverogre.com',
            wp_normalize_path(__FILE__),
            wp_normalize_path(plugin_dir_path(__FILE__)),
            false
        );

        // Set Text Domain
        load_plugin_textdomain('wpjm-jobadder', false, plugin_basename(dirname(__FILE__)) . '/lang');

        // Plugin Filters
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), array(__CLASS__, 'action_links'));

        // Delay loading classes
        add_action('plugins_loaded', array(__CLASS__, 'load'), 10, 0);
    }

    static function load() {
        // Load API Classes
        include_once(\JobAdder\Settings::get('path') . 'inc/api/utility.php'); // API url & curl functions
        include_once(\JobAdder\Settings::get('path') . 'inc/api/auth.php'); // API OAuth2.0 Authentication
        include_once(\JobAdder\Settings::get('path') . 'inc/api/jobs.php'); // Jobs
        include_once(\JobAdder\Settings::get('path') . 'inc/api/jobads.php'); // JobAds
        include_once(\JobAdder\Settings::get('path') . 'inc/api/contacts.php'); // Contacts
        include_once(\JobAdder\Settings::get('path') . 'inc/api/companies.php'); // Companies

        // Load XML Feed Classes
        include_once(\JobAdder\Settings::get('path') . 'inc/feed.php'); // REST API Routes for Job Feed & WebHooks

        // Load WPJM Classes
        include_once(\JobAdder\Settings::get('path') . 'inc/job-listing.php'); // WPJM Job Listing fields and functions
    }

    // Plugin Action Links

    static function action_links($links) {
        array_unshift($links, '<a href="' . esc_url(admin_url('edit.php?post_type=job_listing&page=wpjm-jobadder_settings')) . '">' . __('Settings', 'wpjm-jobadder') . '</a>');
        return $links;
    }

    // Plugin File Path Calculations
    private static function get_path($file) {
        return trailingslashit(dirname($file));
    }
    private static function get_dir($file) {
        $dir = trailingslashit(dirname($file));
        $count = 0;

        // Sanitize for Win32 installs
        $dir = str_replace('\\', '/', $dir);

        // If file is in plugins folder
        $wp_plugin_dir = str_replace('\\', '/', WP_PLUGIN_DIR);
        $dir = str_replace($wp_plugin_dir, plugins_url(), $dir, $count);

        if ($count < 1) {
            // If file is in wp-content folder
            $wp_content_dir = str_replace('\\', '/', WP_CONTENT_DIR);
            $dir = str_replace($wp_content_dir, content_url(), $dir, $count);
        }

        if ($count < 1) {
            // If file is in ??? folder
            $wp_dir = str_replace('\\', '/', ABSPATH);
            $dir = str_replace($wp_dir, site_url('/'), $dir);
        }

        return $dir;
    }
    private static function get_hook($file) {
        return basename(dirname($file)) . '/' . basename($file);
    }
}

\JobAdder\Plugin::init();
