<?php
/**
 * Plugin Name: OgreSchema
 * Plugin URI: https://plugins.cleverogre.com/plugin/ogreschema/
 * Description: Output schema site-wide for your website.
 * Version: 0.1.2
 * Requires at Least: 6.0
 * Requires PHP: 8.0
 * Author: CleverOgre
 * Author URI: https://cleverogre.com/
 * License: GPLv3 or later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain: ogreschema
 * Domain Path: /lang
 * Update URI: https://plugins.cleverogre.com/plugin/ogreschema/
 * Icon1x: https://plugins.cleverogre.com/plugin/ogreschema/?asset=icon-sm
 * Icon2x: https://plugins.cleverogre.com/plugin/ogreschema/?asset=icon
 * BannerHigh: https://plugins.cleverogre.com/plugin/ogreschema/?asset=banner
 * BannerLow: https://plugins.cleverogre.com/plugin/ogreschema/?asset=banner-sm
 * Copyright: © 2024 CleverOgre, Inc. All rights reserved.
 */

namespace OgreSchema;

defined('ABSPATH') || exit;

// Load Base Requirements
include_once(__DIR__ . '/includes/trait-singleton.php');
include_once(__DIR__ . '/includes/abstract-plugin-base.php');

class Plugin extends PluginBase {

    public function __construct() {
        parent::__construct(__FILE__);

        $this->add_requirement('advanced-custom-fields', [
            'name' => 'Advanced Custom Fields PRO',
            'url' => 'https://www.advancedcustomfields.com/',
            'type' => self::REQUIREMENT_CLASS,
            'class' => '\ACF',
        ]);

        $this->add_files([
            'includes/class-data.php',
            'includes/class-settings.php',
            'includes/class-fields.php',
            'includes/class-output.php',
            'includes/integration/class-wordpress-seo.php',
        ]);
    }

}

Plugin::instance();
