<?php
/**
 * @package WooCommerce
 * @subpackage NewtekGateway
 * @version 1.2.0
 * @since 1.2.0
 */

namespace WooCommerce\NewtekGateway;

defined('ABSPATH') || exit;

use \Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use \Automattic\WooCommerce\StoreApi\Payments\PaymentContext;
use \Automattic\WooCommerce\StoreApi\Payments\PaymentResult;

final class BlockSupport extends AbstractPaymentMethodType {

	private $gateway;
	protected $name;

	public function __construct() {
		$this->name = Plugin::get_id();
	}

	private function get_option_key() {
		return 'woocommerce_' . $this->name . '_settings';
	}

	public function initialize() {
		$this->settings = get_option($this->get_option_key(), []);
		$this->gateway  = new PaymentGateway();
	}

	public function is_active() {
		return $this->gateway->is_available();
	}

	public function get_payment_method_script_handles() {
		$script_path       = 'assets/js/frontend/blocks.js';
		$script_asset_path = trailingslashit(Plugin::get_path()) . 'assets/js/frontend/blocks.asset.php';
		$script_asset      = file_exists($script_asset_path) ? require($script_asset_path) : [
			'dependencies' => [],
			'version'      => filemtime(trailingslashit(Plugin::get_path()) . $script_path),
		];
		$script_url        = trailingslashit(Plugin::get_dir()) . $script_path;

		$style_path       = 'assets/css/frontend.css';
		$style_url		   = trailingslashit(Plugin::get_dir()) . $style_path;

		wp_register_script(
			Plugin::get_id('block'),
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		wp_register_style(
			Plugin::get_id('block'),
			$style_url,
			[],
			filemtime(trailingslashit(Plugin::get_path()) . $style_path)
		);

		if (function_exists('wp_set_script_translations')) {
			wp_set_script_translations(Plugin::get_id('block'), Plugin::get_textdomain(), trailingslashit(Plugin::get_path()) . 'lang/');
		}

		wp_enqueue_style(Plugin::get_id('block'));

		return [Plugin::get_id('block')];
	}

	public function get_payment_method_data() {
		return [
			'title'       => $this->get_setting('title'),
			'description' => $this->get_setting('description'),
			'supports'    => array_filter($this->gateway->supports, [$this->gateway, 'supports']),
			'assets_url' => trailingslashit(Plugin::get_dir()) . 'assets/',
		];
	}
}
